$(function(){
    initpage();
    $(document).keydown(function (event) {
        if (event.keyCode == 13) { 
            login();
        }
      });
});

function initpage(){
    sessionStorage.clear();
    var qrcode = GetQueryString("state");//二维码验证------
    if (qrcode != undefined && qrcode != '') {
        var code = GetQueryString("code"); //用户信息码
        if (code != "" && code != null && code != undefined) {
            getUserId(code);
        }
    }
}


function sweepcode(){
    window.WwLogin({
        "id" : "QRcode",  
        "appid" : "ww3efe58b4d8a2c0d0",//damogong
        // "appid" :"wwf2de19d56686cfdd",//prod
        "agentid" : "1000010",//damogong
        // "agentid" : "1000029",
        "redirect_uri" : UrlEncode("https://www.damogong.com:444/portal/login.html"),
        "state" : "qrcode",
        "href" : ""
    });
}

//账号密码登录
function login(){
    if(checkaccount('login') && checkpassword('login')){
        var token = "";
        var username = "";
        var userrole = "";
        var userid = "";
        var data={
            "account": $("#account").val(),
            "password": $("#password").val()
        };
        $.ajax({
            type: "POST",
            url : ngpath + "/auth/user/login",
            contentType: 'application/json',
            dataType : "json",
            data :  JSON.stringify(data), //post请求方式必须将参数转换为JSON对象
            success : function(result) {
                if(result.code == '200'){
                    token = result.data.token;
                    username = result.data.userDetail.username;
                    roleid = result.data.userDetail.role.id;
                    userid = result.data.userDetail.id;
                    sessionStorage.setItem('token',token);
                    sessionStorage.setItem('username',username);
                    sessionStorage.setItem('roleid',roleid);
                    sessionStorage.setItem('userid',userid);
                    getUserInfo();
                   
                }else{
                    $("#passwordcheck").html(result.msg);
                    $("#passwordcheck").show();
                }
            },
            error : function(error) {
                layer.msg("网络原因，操作失败！");
            }
        });	
    }
}

//验证邮箱不能为空
function checkaccount(type){
    var account = $("#account").val();
    if(account == "" || account == null || account == undefined){
		layer.msg("请填写邮箱信息!");
        // $("#accountcheck").html("邮箱不能为空");
        // $("#accountcheck").show();
             return false;
    }else{
		sendCodeAdnEmail();
        // $("#accountcheck").html("");
        // $("#accountcheck").hide();
        return true;
    }
}

//密码非空、长度验证
function checkpassword(){
    var password = $("#password").val();
    if(password == "" || password == null || password == undefined){
        $("#passwordcheck").html("密码不能为空");
        $("#passwordcheck").show();
        return false;
    }else{
        if(password.length < 6){
            $("#passwordcheck").html("密码长度为6-20之间");
            $("#passwordcheck").show();
            return false;
        }else{
            $("#passwordcheck").html("");
            $("#passwordcheck").hide();
            return true;
        }
    }
}

function UrlEncode(str) 
{ 
    return transform(str); 
} 
    
function transform(s) 
{ 
    var hex=''    
    var i,j,t 
        
    j=0 
    for (i=0; i<s.length; i++) 
    { 
        t = hexfromdec( s.charCodeAt(i) ); 
        if (t=='25') 
        { 
            t=''; 
        } 
        hex += '%' + t; 
    } 
    return hex; 
} 
    
function hexfromdec(num) { 
    if (num > 65535) { 
        return ("err!") 
    } 
    first = Math.round(num/4096 - .5); 
    temp1 = num - first * 4096; 
    second = Math.round(temp1/256 -.5); 
    temp2 = temp1 - second * 256; 
    third = Math.round(temp2/16 - .5); 
    fourth = temp2 - third * 16; 
    return (""+getletter(third)+getletter(fourth)); 
} 
    
function getletter(num) { 
    if (num < 10) { 
        return num; 
    } 
    else { 
        if (num == 10) { return "A" } 
        if (num == 11) { return "B" } 
        if (num == 12) { return "C" } 
        if (num == 13) { return "D" } 
        if (num == 14) { return "E" } 
        if (num == 15) { return "F" } 
    } 
} 

function GetQueryString(name)
{
     var reg = new RegExp("(^|&)"+ name +"=([^&]*)(&|$)");
     var r = window.location.search.substr(1).match(reg);//search,查询？后面的参数，并匹配正则
     if(r!=null)return  unescape(r[2]); return null;
}

//--------------------------------处理扫码登录问题---------------------------------
//获取用户ID
function getUserId(code) {
    $.ajax({
        url: getRequestUrl("/weixin/wxuserinfo/" + code),
        dataType: "json",
        type: "get",
        headers:{
			"Content-Type" : "application/json;charset=utf-8",
			"Authorization" : "",
		},
        success: function (result) {
            if (result.opflag) {
                getQrcodeLoginToken(result.userid);
            } else {
                alert(result.opmessage|"企业微信信息认证失败！");
            }
        },
        error: function (error) {
            alert("网络原因，操作失败!");
        }
    });
}

//获取用户信息
function getQrcodeLoginToken(userid) {
    $.ajax({
        url: getRequestUrl("/auth/v1/qrcodelogin/" + userid),
        dataType: "json",
        headers:{
			"Content-Type" : "application/json;charset=utf-8",
			"Authorization" : "",
		},
        type: "get",
        success: function (result) {
            if (result.code == '200') {
                token = result.data.token;
                username = result.data.userDetail.username;
                roleid = result.data.userDetail.role.id;
                userid = result.data.userDetail.id;
                sessionStorage.setItem('token', token);
                sessionStorage.setItem('username', username);
                sessionStorage.setItem('roleid', roleid);
                sessionStorage.setItem('userid', userid);
                getUserInfo();
            } else {
                alert("扫码登录异常，请联系管理员！");
                sessionStorage.clear();
            }
        },
        error: function (error) {
            alert("网络原因，操作失败!");
        }
    });
}
// //用户信息
// var department = ""; //用户所属机构id
// function getUserInfo() {
//     var parameterData = {
//         url: path + "/auth/v1/user",
//         successfunc: userInfoDataFun,
//     };
//     requestAjax(parameterData)
// }
// var delength=0;
// var delengthcount=0;
// function userInfoDataFun(result) {
//     if (result.code == '200') {
//         department = result.data.platformPersonnel.department;
//         var deaarr = department.split(",")
       
//         if (deaarr.length > 0) {
//             delength=deaarr.length;
//             deaarr.forEach(element => {
//                 getDepartments(element);
//             });
//         }else{
//             pageForward("/index.html");
//         }
//         // pageForward("/index.html");
//     } else {
//         layer.msg('网络原因，获取信息失败!');
//     }
// }
//当前用户上级机构id
var departmentArr = "";
function getDepartments(id) {
    var parameterData = {
        url: path + "/department/list/" + id,
        successfunc: departmentsDataFun,
    };
    requestAjax(parameterData);
}
function departmentsDataFun(result) {
    
    delengthcount=delengthcount+1;
    if (result.code == '200') {
        var arr = result.data;
        if (arr != null && arr.length > 0) {
            for (var i = 0; i < arr.length; i++) {
                if (i == 0) {
                    departmentArr = arr[i].id;
                } else {
                    departmentArr = departmentArr + "," + arr[i].id;
                }

            }
        }
        sessionStorage.setItem('departmentArr', departmentArr);
        
    } else {
        layer.msg('网络原因，获取信息失败!');
    }
    if (delengthcount==delength) {
        pageForward("/index.html");
    }
   

}
//--------------------------------处理扫码登录问题---------------------------------END

