//引入gulp
var gulp = require("gulp");
var babel = require('gulp-babel');
var gulpHtmlMin = require('gulp-htmlmin');
var gulpCssMin = require('gulp-clean-css');
var rename = require('gulp-rename');//重命名
var gulpJsmin = require('gulp-uglify');
var gulpImgsmin = require('gulp-imagemin');
//var connect = require('gulp-connect');
var sequence = require('run-sequence');
var clean = require('gulp-clean');
//var gutil = require('gulp-util');
var rev = require('gulp-rev');//- 对文件名加MD5后缀
var revCollector = require('gulp-rev-collector');//- 路径替换
var uicssSrc = 'assets/ui_css/*.css';//压缩后移动
 var uijsSrc = 'assets/ui_js/*.js';//压缩后移动
 var cssSrc = 'assets/css/**';//只移动
 var jsSrc = 'assets/js/**';//只移动
 var imgSrc = 'assets/images/**';//只移动
 var jqueryEZViewSrc='jqueryEZView/**';//只移动
 var jquerypdfSrc='pdf.js-gh-pages/**';//只移动
 var fontSrc='assets/fonts/**';//只移动
  var layerSrc='assets/layer/**';//只移动
  var icoSrc='./favicon.ico';
//资源文件跨域配置
var cors = function (req, res, next) {
res.setHeader('Access-Control-Allow-Origin', '*');
next();
};
gulp.task('default', function (cb) { //检测gulp是否启动
console.log("gulp启动了");
//cb(err);
});

//压缩css
gulp.task('uicssmin', function () {
return gulp.src(uicssSrc)
.pipe(gulpCssMin())
.pipe(rev()) 
.pipe(gulp.dest('dist/assets/ui_css/'))
.pipe(rev.manifest()) 
.pipe(gulp.dest('./rev/css'))
});

//压缩js
gulp.task('uijsmin', function () { 
//注意，js中可能有多个文件夹，比如说一些插件一些类库之类的,
//所以看你需求而定路径写对就行
return gulp.src(uijsSrc)
.pipe(babel({presets: ['es2015'] }))// es5检查机制
.pipe(gulpJsmin({ mangle: { toplevel: false } }))
.on('error', function(err) { gutil.log(gutil.colors.red('[Error]'), err.toString());})
.pipe(rev()) 
.pipe(gulp.dest('dist/assets/ui_js/'))
.pipe(rev.manifest()) 
.pipe(gulp.dest('./rev/js'))
});
//移动图片
gulp.task('imagesmin', function () {
return gulp.src(imgSrc)
//.pipe(gulpImgsmin())
//.pipe(rev()) 
.pipe(gulp.dest("dist/assets/images/"))
//.pipe(rev.manifest()) 
//.pipe(gulp.dest('./rev/images'))
//.pipe(connect.reload())
});
//移动字体
  gulp.task('fontmin', function () {
return gulp.src(fontSrc)
.pipe(gulp.dest("dist/assets/fonts/"))
});
 
//移动已经压缩css
  gulp.task('cssSrcmin', function () {
return gulp.src(cssSrc)
.pipe(gulp.dest("dist/assets/css/"))
});
//移动已经压缩js
  gulp.task('jsSrcmin', function () {
return gulp.src(jsSrc)
.pipe(gulp.dest("dist/assets/js/"))
});


//移动控件
  gulp.task('jqueryEZViewmin', function () {
return gulp.src(jqueryEZViewSrc)
.pipe(gulp.dest("dist/jqueryEZView/"))
});
//移动控件
  gulp.task('jqueryPdf', function () {
return gulp.src(jquerypdfSrc)
.pipe(gulp.dest("dist/pdf.js-gh-pages/"))
});
//移动控件
 gulp.task('layermin', function () {
return gulp.src(layerSrc)
.pipe(gulp.dest("dist/assets/layer/"))
});

 gulp.task('icomin', function () {
return gulp.src(icoSrc)
.pipe(gulp.dest("dist/"))
});
// 替换1
gulp.task('rev_css', function() {
return gulp.src(['./rev/css/*.json', './*.html']) //- 读取 rev-manifest.json 文件以及需要进行css名替换的文件
.pipe(revCollector()) //- 执行文件内css名的替换
.pipe(gulp.dest('./rev/html_css/'))//- 替换后的文件输出的目录
});
// 替换3
gulp.task('rev_js', function() {
return gulp.src(['./rev/js/*.json', './rev/html_css/*.html']) //- 读取 rev-manifest.json 文件以及需要进行css名替换的文件
.pipe(revCollector()) //- 执行文件内js名的替换
.pipe(gulp.dest('./rev/html/'))//- 替换后的文件输出的目录
});

// 替换2
gulp.task('rev_com_css', function() {
return gulp.src(['./rev/css/*.json', './common/*.html']) //- 读取 rev-manifest.json 文件以及需要进行css名替换的文件
.pipe(revCollector()) //- 执行文件内css名的替换
.pipe(gulp.dest('./rev/html_common_css/'))//- 替换后的文件输出的目录
});

// 替换4
gulp.task('rev_com_js', function() {
return gulp.src(['./rev/js/*.json', './rev/html_common_css/*.html']) //- 读取 rev-manifest.json 文件以及需要进行css名替换的文件
.pipe(revCollector()) //- 执行文件内js名的替换
//.pipe(gulpHtmlMin({ //删除空格
//collapseWhitespace: true, //删除注释
//removeComments: true
//}))
.pipe(gulp.dest('./rev/html_common/'))//- 替换后的文件输出的目录
});
//引入压缩html所需的模块
gulp.task('htmlmin', function () { //可以单个压缩
return gulp.src('./rev/html/*.html')
.pipe(gulpHtmlMin({ //删除空格
collapseWhitespace: true, //删除注释
removeComments: true
}))
.pipe(gulp.dest('dist/'))
//.pipe(connect.reload())
});
//引入压缩html所需的模块
gulp.task('htmlcommin', function () { //可以单个压缩
return gulp.src('./rev/html_common/*.html')
.pipe(gulpHtmlMin({ //删除空格
collapseWhitespace: true, //删除注释
removeComments: true
}))
.pipe(gulp.dest('dist/common/'))
//.pipe(connect.reload())
});

gulp.task("clean", function (cb) {
return gulp.src('./dist/*', {read: false})
.pipe(clean({force: true}));})
 gulp.task("cleanrev", function (cb) {
return gulp.src('./rev/*', {read: false})
.pipe(clean({force: true}));})


gulp.task('build', function () {
//同步执行先clean 在异步执行打包
//任务需要加return 否则同步无效 ,
sequence('clean','cleanrev','uicssmin', 'uijsmin','rev_css','rev_js','rev_com_css','rev_com_js',['cssSrcmin','jsSrcmin','imagesmin','icomin','fontmin','jqueryEZViewmin','jqueryPdf','layermin'],'htmlmin','htmlcommin',function () {
console.log("==========build success=============");});
});
