import request from '../../common/utils/request'
/**
 * 考勤-出差列表
 * pageNum=1&pageSize=4&employeesCode=1001
 * @param {{
 *   pageNum: number
 *   pageSize: number
 *   keyWord: number | string 搜索关键字
 * }} data
 * @returns
 */
export function getBusinessTriplist(data) {
  return request({
    url: '/attendance/attMobile/getBusinessTriplist',
    method: 'get',
    params: data
  })
}

/**
 * 考勤-出差新增
 * @param {object} data
 * @param {string} data.location 出差地点
 * @param {string} data.backTime 开始日期
 * @param {string} data.endTime 结束日期
 * @param {string} data.day 出差天数
 * @param {string} data.reason 出差事由
 * @returns
 */
export function addBusinessTrip(data) {
  return request({
    url: '/attendance/attMobile/addBusinessTrip',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-出差修改
 * @param {object} data
 * @param {string} data.id
 * @param {string} data.auditStatus 审核状态
 * @param {string} data.location 出差地点
 * @param {string} data.backTime 开始日期
 * @param {string} data.endTime 结束日期
 * @param {string} data.day 出差天数
 * @param {string} data.reason 出差事由
 * @returns
 */
export function updateBusinessTrip(data) {
  return request({
    url: '/attendance/attMobile/updateBusinessTrip',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-出差关闭
 * @param {{
 *   businessTripId: string
 *   backTime: string
 *   remark: string
 * }} data
 * @returns
 */
export function addBusinessTripBack(data) {
  return request({
    url: '/attendance/attMobile/addBusinessTripBack',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-出差详情
 * @param {string} businessTripId id
 * @returns
 */
export function getBusinessTrip(businessTripId) {
  return request({
    url: `/attendance/attMobile/getBusinessTrip/${businessTripId}`,
    method: 'get'
  })
}

/**
 * 考勤-出差关闭详情
 * @param {string} businessTripId id
 * @returns
 */
export function getBusinessTripBack(businessTripId) {
  return request({
    url: `/attendance/attMobile/getBusinessTripBack/${businessTripId}`,
    method: 'get'
  })
}