import request from '@/common/utils/request'

/**
 * 安全隐串列表
 * @param {Object} data
 * @param {number} data.pageNum
 * @param {number} data.pageSize
 * @param {string} data.dangerStatus 全部(空) 2处理中 3超期 4已结束
 */
export function securityInspectDangerMobileList(data) {
  return request({
    url: '/business/securityInspectDangerMobile/list',
    method: 'get',
    params: data
  })
}

/**
 * 安全隐串详情
 * @param {string} id
 */
export function securityInspectDangerMobileDetail(id) {
  return request({
    url: '/business/securityInspectDangerMobile/' + id,
    method: 'get'
  })
}

/**
 * 隐患验收
 * @param {Object} data
 */
export function acceptEdit(data) {
  return request({
    url: '/business/securityInspectDangerMobile/acceptEdit',
    method: 'post',
    data
  })
}

/**
 * 隐患验收
 * @param {Object} data
 */
export function fixEdit(data) {
  return request({
    url: '/business/securityInspectDangerMobile/fixEdit',
    method: 'post',
    data
  })
}

/**
 * 转派
 * @param {Object} data
 * @param {string} data.id 主键id
 * @param {string} data.transferUserId 用户id
 * @param {string} data.transferUserName 用户名
 * @param {string} data.transferremark 备注
 */
export function transferEdit(data) {
  return request({
    url: '/business/securityInspectDangerMobile/transferEdit',
    method: 'post',
    data
  })
}

/**
 * 催办
 * @param {Object} data
 */
export function transferUrgent(data) {
  return request({
    url: '/business/securityInspectDangerMobile/onUrgent',
    method: 'post',
    data
  })
}
