export function base64ToFile(base64, fileName) {
  let arr = base64.split(',')
  let mime = arr[0].match(/:(.*?);/)[1]
  let bstr = atob(arr[1])
  let n = bstr.length
  let u8arr = new Uint8Array(n)

  while (n--) {
    u8arr[n] = bstr.charCodeAt(n)
  }
  return new File([u8arr], fileName, { type: mime })
}

// 使用示例
// const base64Str = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAA...' // 这里应该是完整的base64字符串
// const filename = 'image.png'
// const mimeType = 'image/png'
// const file = base64ToFile(base64Str, filename, mimeType)