import request from '@/common/utils/request'

// 任务执行-列表查询
export function listManageTaskExecute(query) {
  return request({
    url: '/business/manageTaskExecute/list',
    method: 'get',
    params: query
  })
}

// 新增事务管理任务执行转派历史
export function addManageTaskTransfer(data) {
  return request({
    url: '/business/manageTaskTransfer',
    method: 'post',
    data: data
  })
}

// 查询事务管理任务执行检讨详细
export function getManageTaskExecute(id) {
  return request({
    url: '/business/manageTaskExecute/' + id,
    method: 'get'
  })
}

// 任务执行提交接口
export function handle(data) {
  return request({
    url: '/business/manageTaskExecuteMobile/handle',
    method: 'post',
    data: data
  })
}

// 任务执行检讨提交
export function review(data) {
  return request({
    url: 'business/manageTaskExecuteMobile/review',
    method: 'post',
    data: data
  })
}

// 获取点检表信息
export function checkTableManageMobile(id) {
  return request({
    url: 'business/checkTableManageMobile/'+id,
    method: 'get',
  })
}

// 获取点检的详情
export function recordInfo(query) {
  return request({
    url: 'business/checkTableManageMobile/recordInfo',
    method: 'get',
    params: query
  })
}