import request from '@/common/utils/request'

/**
 * 食堂菜谱发布-列表
 * pageNum=1&pageSize=4&reason=1001
 * @param {{
*   pageNum: number
*   pageSize: number
* }} data
* @returns
*/
export function tAmMenuReleaseMobileList(data) {
  return request({
    url: '/business/tAmMenuReleaseMobile/list',
    method: 'get',
    params: data
  })
}

/**
 * 一周餐谱
 * @param id 餐谱id
 * @returns
 */
export function weekMenu(data) {
  return request({
    url: '/business/tAmMenuReleaseMobile/showMenu',
    method: 'get',
    params: data
  })
}

