import { useRoute } from 'vue-router'
import Qs from 'qs'
import { useAppStoreHook } from '@/store/modules/app'

const appStore = useAppStoreHook()

const decode = (str) => {
  return decodeURIComponent(decodeURIComponent(str))
}

const hashParam = Qs.parse(decode(location.hash).split('?')[1] || '') // hash 参数 {object}
const searchParam = Qs.parse(decode(location.search.replace(/\?/, ''))) // urlParams {object}

// url replace 参数
const path = Object.prototype.hasOwnProperty.call(searchParam, 'entry') ? searchParam.entry : decode(location.hash).replace(/#/, '').split('?')[0] || '' // hash 路由 {string}

// get code url
const getWxCodeUrl = (paramsResult: any = {}) => {
  // let _shareScope = searchParam.shareScope || 'snsapi_userinfo' || 'snsapi_base' || 'snsapi_privateinfo
  const _shareScope = searchParam.shareScope || 'snsapi_privateinfo'
  if (hashParam) {
    paramsResult = Object.assign(paramsResult, hashParam)
  }
  if (searchParam) {
    delete searchParam.entry
    paramsResult = Object.assign(paramsResult, searchParam)
  }
  delete paramsResult.rand
  const entry = path ? '?entry=' + path : ''
  paramsResult = Object.keys(paramsResult).length ? `${entry ? '&' : '?'}${Qs.stringify(paramsResult)}` : ''
  const redirectUrl = `${location.origin}${location.pathname}${entry}${paramsResult}`
  // debugger
  // console.log('appStore.appid', appStore.appid)
  return `https://open.weixin.qq.com/connect/oauth2/authorize?appid=${appStore.appid}&agentid=${appStore.agentid}&redirect_uri=${encodeURIComponent(redirectUrl)}&response_type=code&scope=${_shareScope}&state=123#wechat_redirect`
}

// set url
const setUrl = (paramsResult: any = {}) => {
  if (hashParam) {
    paramsResult = Object.assign(paramsResult, hashParam)
  }
  if (searchParam) {
    // 去掉 code & state & entry & shareScope
    delete searchParam.entry
    delete searchParam.code
    delete searchParam.state
    delete searchParam.shareScope
    paramsResult = Object.assign(paramsResult, searchParam)
  }
  delete searchParam.from
  delete paramsResult.rand
  paramsResult = Object.keys(paramsResult).length ? `&${Qs.stringify(paramsResult)}` : ''
  return `${location.origin}${location.pathname}?rand=${Math.random()}${path}${paramsResult}`
}

const getWxShareUrl = (paramsResult: any = {}) => {
  const path = paramsResult.path ? paramsResult.path : decode(location.hash).replace(/#/, '').split('?')[0] || ''
  const hashParam = paramsResult.query ? paramsResult.query : Qs.parse(decode(location.hash).split('?')[1] || '') // hash 参数 {object}
  const searchParam = paramsResult.search ? paramsResult.search : Qs.parse(decode(location.search.replace(/\?/, ''))) // urlParams {object}
  if (hashParam) {
    paramsResult = Object.assign(hashParam, paramsResult)
  }
  if (searchParam) {
    // 去掉 code & state & entry & shareScope
    paramsResult = Object.assign(searchParam, paramsResult)
  }
  delete paramsResult.shareScope
  delete paramsResult.query
  delete paramsResult.search
  delete paramsResult.rand
  // 传参有fullPath时
  const route = useRoute()
  const entry = path ? '?entry=' + encodeURIComponent(route.path) : ''
  delete paramsResult.fullPath
  paramsResult = Object.keys(paramsResult).length ? `${entry ? '&' : '?'}${Qs.stringify(paramsResult)}` : ''
  return `${location.origin}${location.pathname}${entry}${paramsResult}`
}

export {
  getWxCodeUrl,
  setUrl,
  getWxShareUrl
}
