/**
 * 流程引擎相关方法接口
 */
import request from '../../common/utils/request'

// 待办列表
export function getTodoList(data) {
  return request({
    url: '/flowEngine/mobileflow/getTodoList',
    method: 'post',
    data
  })
}

// 已办列表
export function getDoneList(data) {
  return request({
    url: '/flowEngine/mobileflow/getDoneList',
    method: 'post',
    data
  })
}

// 已发列表
export function querySendList(data) {
  return request({
    url: '/flowEngine/mobileflow/querySendList',
    method: 'post',
    data
  })
}

// 抄送我的
export function queryChaoSList(data) {
  return request({
    url: '/flowEngine/mobileflow/queryChaoSList',
    method: 'post',
    data
  })
}


/**
 * 查看流程图(已启动的流程实例)
 * @param {string} instanceId 实例id
 * @returns
 */
export function getFlowChart(data) {
  return request({
    url: '/flowEngine/flowApiController/getFlowChart',
    method: 'post',
    data
  })
}

/**
 * 审批通过
 */
export function completeTask(data: {
  instanceId: string // 实例id
  taskId: string // 任务id
  auditOpinion: string // 审批意见
  doUserId: string // 审批人ID
  doUserName: string // 审批人姓名
  customData: {
    pass: '1' // '0'拒绝  '1'同意
  }
  addUserList: any
}) {
  return request({
    url: '/flowEngine/flowApiController/completeTask',
    method: 'post',
    data
  })
}

/**
 * 审批拒绝
 */
export function refuseFlow(data: {
  instanceId: string // 实例id
  taskId: string // 任务id
  auditOpinion: string // 审批意见
  doUserId: string // 审批人ID
  doUserName: string // 审批人姓名
  customData: {
    pass: '0' // '0'拒绝  '1'同意
  }
  addUserList: any
}) {
  return request({
    url: '/flowEngine/flowApiController/refuseFlow',
    method: 'post',
    data
  })
}

/**
 * 个人撤办
 */
export function revokeProcess(data: {
  instanceId: string // 实例id
}) {
  return request({
    url: '/flowEngine/flowApiController/revokeProcess',
    method: 'post',
    data
  })
}