import { ref } from 'vue'
import { queryCompanyList } from '@/api/system/user'

const companyList = ref(await queryCompanyList({}))

const findLabel = (arr: any[], target: string, labelName: string, idName: string) => {
  let res = ''
  function find(arr: any[], target: string, labelName: string, idName: string) {
    for (let i = 0; i < arr.length; i += 1) {
      if (arr[i][idName] === target) {
        res = arr[i][labelName]
        return
      }
    }
  }
  find(arr, target, labelName, idName)
  return res
}

export const getCompanyName = (id: string) => {
  const name = findLabel(companyList.value.data, id, 'companyName', 'companyCode')
  return name
}

export const refreshCompanyList = async () => {
  companyList.value = await queryCompanyList({})
}

export const getCompanyList = () => {
  return companyList.value.data
}