import request from '@/common/utils/request'

// 查询事务管理工单管理列表
export function listManageWorkOrder(query) {
  return request({
    url: '/business/manageWorkOrder/list',
    method: 'get',
    params: query
  })
}

// 查询事务管理工单管理详细
export function getManageWorkOrderMobile(id) {
  return request({
    url: '/business/manageWorkOrderMobile/' + id,
    method: 'get'
  })
}

// 工单新增
export function manageWorkOrderMobile(data) {
  return request({
    url: '/business/manageWorkOrderMobile',
    method: 'post',
    data: data
  })
}

// 提交工单处理结果
export function handleConfirm(data) {
  return request({
    url: '/business/manageWorkOrderMobile/handleConfirm',
    method: 'post',
    data: data
  })
}

// 工单催办
export function onUrgent(data) {
  return request({
    url: '/business/manageWorkOrderMobile/onUrgent',
    method: 'post',
    data: data
  })
}