import request from '../../common/utils/request'

// 签卡申请-列表查询
export function getRegistrationCardList(query) {
  return request({
    url: '/attendance/attMobile/getRegistrationCardList',
    method: 'get',
    params: query
  })
}

// 签卡申请-详情
export function getRegistrationCardDetail(id) {
  return request({
    url: '/attendance/attMobile/getRegistrationCardDetail/' + id,
    method: 'get'
  })
}

/**
 * 签卡申请-提交
 * @param data
 * @param {string} data.recordItemDurationId 班次明细id
 * @param {string} data.checkType 签卡类型 1上班签卡 2下班签卡
 * @param {string} data.signTime 签卡时间
 * @param {string} data.oriSignTime 原打卡时间
 * @param {string} data.signReason: '' // 签卡事由
 */
export function registrationCard(data) {
  return request({
    url: '/attendance/attMobile/registrationCard',
    method: 'post',
    data: data
  })
}

/**
 * 签卡申请-修改
 * @param data
 * @param {string} data.id
 * @param {string} data.auditStatus 审核状态
 * @param {string} data.recordItemDurationId 班次明细id
 * @param {string} data.checkType 签卡类型 1上班签卡 2下班签卡
 * @param {string} data.signTime 签卡时间
 * @param {string} data.oriSignTime 原打卡时间
 * @param {string} data.signReason 签卡事由
 */
export function updateTAttRegistrationCard(data) {
  return request({
    url: '/attendance/attMobile/updateTAttRegistrationCard',
    method: 'post',
    data: data
  })
}