import request from '../../common/utils/request'

/**
 * 考勤-加班调休列表
 * @param {object} data 查询参数
 * @param {object} data.pageNum 页数
 * @param {object} data.pageSize 条数
 * @param {object} data.location 当日外出地点
 */
export function getOutsideApplylist(data) {
  return request({
    url: '/attendance/attMobile/getOutsideApplylist',
    method: 'get',
    params: data
  })
}

/**
 * 考勤-当日外出新增
 * @param {object} data 提交数据
 * @param {string} data.location 当日外出地点
 * @param {string} data.outsideDate 当日外出日期
 * @param {string} data.expectBeginTime 预计当日外出开始时间
 * @param {string} data.expectEndTime 预计当日外出结束时间
 * @param {string} data.reason 当日外出事由
 */
export function addOutsideApply(data) {
  return request({
    url: '/attendance/attMobile/addOutsideApply',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-当日外出更新
 * @param {object} data 提交数据
 * @param {string} data.id
 * @param {string} data.auditStatus 审核状态
 * @param {string} data.location 当日外出地点
 * @param {string} data.outsideDate 当日外出日期
 * @param {string} data.expectBeginTime 预计当日外出开始时间
 * @param {string} data.expectEndTime 预计当日外出结束时间
 * @param {string} data.reason 当日外出事由
 */
export function editOutsideApply(data) {
  return request({
    url: '/attendance/attMobile/editOutsideApply',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-当日外出详情
 * @param {string} id id
 */
export function getOutsideApplyInfo(id) {
  return request({
    url: `/attendance/attMobile/getOutsideApplyInfo/${id}`,
    method: 'get'
  })
}