import request from '../../common/utils/request'

/**
 * 考勤-加班调休列表
 * pageNum=1&pageSize=4&employeesCode=1001
 * @param {{
 *   pageNum: number
 *   pageSize: number
 *   reason: number | string 搜索关键字
 * }} data
 * @returns
 */
export function getWorkOverTimeForLeaveList(data) {
  return request({
    url: '/attendance/attMobile/getWorkOverTimeForLeaveList',
    method: 'get',
    params: data
  })
}

/**
 * 考勤-调休新增
 * @param {object} data
 * @param {string} data.workOverTimeType 加班调休类型
 * @param {string} data.backTime 开始时间
 * @param {string} data.endTime 结束时间
 * @param {string} data.hour 调休时长(小时)
 * @param {string} data.reason 调休事由
 * @returns
 */
export function addWorkOverTimeForLeave(data) {
  return request({
    url: '/attendance/attMobile/addWorkOverTimeForLeave',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-调休修改
 * @param {object} data
 * @param {string} data.id
 * @param {string} data.auditStatus 审核状态
 * @param {string} data.workOverTimeType 加班调休类型
 * @param {string} data.backTime 开始时间
 * @param {string} data.endTime 结束时间
 * @param {string} data.hour 调休时长(小时)
 * @param {string} data.reason 调休事由
 * @returns
 */
export function updateWorkOverTimeForLeave(data) {
  return request({
    url: '/attendance/attMobile/updateWorkOverTimeForLeave',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-调休详情
 * @param {string} id id
 * @returns
 */
export function getWorkOverTimeForLeave(id) {
  return request({
    url: `/attendance/attMobile/getWorkOverTimeForLeave/${id}`,
    method: 'get'
  })
}

/**
 * 考勤-调休详情（加班/异常加班/集体调休）
 * @param {string} id id
 * @returns
 */
export function getOverWorkInfo(id) {
  return request({
    url: `/attendance/attMobile/getOverWorkInfo/${id}`,
    method: 'get'
  })
}