import request from '../../common/utils/request'
// 查询员工生活物质申请列表
export function listEmployeesLifeMaterial(query) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/list',
    method: 'get',
    params: query
  })
}
// 查询员工档案详细 by code
export function getEmployeesByCode(employeesCode) {
  return request({
    url: '/personnelManagement/employees/getEmployeesByCode/' + employeesCode,
    method: 'get'
  })
}


// 修改员工生活物质申请
export function updateEmployeesLifeMaterial(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/edit',
    method: 'post',
    data: data
  })
}

// 新增员工生活物质申请
export function addEmployeesLifeMaterial(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial',
    method: 'post',
    data: data
  })
}
// 查询员工生活物质申请详细
export function getEmployeesLifeMaterial(id) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/' + id,
    method: 'get'
  })
}

// 提交员工生活物质申请
export function apply(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/apply',
    method: 'post',
    data: data
  })
}


// 删除员工生活物质申请
export function delEmployeesLifeMaterial(id) {
  return request({
    url: '/personnelManagement/employeesLifeMaterial/delete',
    method: 'post',
    data: id
  })
}

// 修改员工生活物质申请
export function confirmployeesLifeMaterial(data) {
  return request({
    url: '/personnelManagement/employeesLifeMaterialConfirm/confirm',
    method: 'post',
    data: data
  })
}
