/**
 * 审批快捷短语
 */
import request from '../../common/utils/request'

/**
 * @function pageList
 * @description 快捷短语列表
 */
export function pageList() {
  return request({
    url: '/flowEngine/handleUserTagController/selectUserTagList',
    method: 'get'
  })
}

/**
 * @function saveTag
 * @description 保存tag
 * @param {string} data 提交数据
 * @param {string} data.tagName 标签名称
 * @param {string} data.tagType 标签类型
 * @param {string} data.sort 排序
 */
export function saveTag(data: {tagName: string, tagType: string, sort: number}) {
  return request({
    url: '/flowEngine/handleUserTagController/saveTag',
    method: 'post',
    data: data
  })
}

/**
 * @function delUsetTagById
 * @description 删除tag
 * @param {string} data 提交数据
 * @param {string} data.id 标签id
 */
export function delUsetTagById(data: {id: string}) {
  return request({
    url: '/flowEngine/handleUserTagController/delUsetTagById',
    method: 'post',
    params: data
  })
}

/**
 * @function updateUsetTagById
 * @description 修改tag
 * @param {string} data 提交数据
 * @param {string} data.id 标签id
 * @param {string} data.tagName 标签名称
 * @param {string} data.tagType 标签类型
 * @param {string} data.sort 排序
 */
export function updateUsetTagById(data: {id: string, tagName: string, tagType: string, sort: number}) {
  return request({
    url: '/flowEngine/handleUserTagController/updateUsetTagById',
    method: 'post',
    data: data
  })
}