import request from '@/common/utils/request'

/**
 * 安全检测报告列表
 * @param {Object} data
 * @param {string|number} data.pageNum
 * @param {string|number} data.pageSize
 * @param {string|number} data.queryYearMonth 年月 2024-05
 * @param {string} data.inspectTheme 检查主题
 */
export function securityInspectReportMobileList(data) {
  return request({
    url: '/business/securityInspectReportMobile/list',
    method: 'get',
    params: data
  })
}

/**
 * 安全检测报告列表
 * @param {string} id
 */
export function securityInspectReportMobileDetail(id) {
  return request({
    url: '/business/securityInspectReportMobile/' + id,
    method: 'get'
  })
}
