import request from '../../common/utils/request'
import { parseStrempty } from '../../common/utils/ruoyi'

/**
 * 查询用户列表
 * @param {any} query
 * @returns
 */
export function listUser(query) {
  return request({
    url: '/system/user/list',
    method: 'get',
    params: query
  })
}

/**
 * 查询用户列表
 * @param {any} query
 * @returns
 */
export function userAll(query) {
  return request({
    url: '/system/user/userAll',
    method: 'get',
    params: query
  })
}

/**
 * 查询用户详细
 * @param {string} userId
 * @returns
 */
export function getUser(userId) {
  return request({
    url: '/system/user/' + parseStrempty(userId),
    method: 'get'
  })
}

/**
 * 新增用户
 * @param {any} data
 * @returns
 */
export function addUser(data) {
  return request({
    url: '/system/user',
    method: 'post',
    data: data
  })
}

/**
 * 修改用户
 * @param {any} data
 * @returns
 */
export function updateUser(data) {
  return request({
    url: '/system/user/edit',
    method: 'post',
    data: data
  })
}

/**
 * 删除用户
 * @param {string} userId
 * @returns
 */
export function delUser(userId) {
  return request({
    url: '/system/user/delete/' + userId,
    method: 'post'
  })
}

/**
 * 用户密码重置
 * @param {string} userId
 * @param {string} password
 * @returns
 */
export function resetUserPwd(userId, password) {
  const data = {
    userId,
    password
  }
  return request({
    url: '/system/user/resetPwd',
    method: 'post',
    data: data
  })
}

/**
 * 用户状态修改
 * @param {string} userId
 * @param {string} status
 * @returns
 */
export function changeUserStatus(userId, status) {
  const data = {
    userId,
    status
  }
  return request({
    url: '/system/user/changeStatus',
    method: 'post',
    data: data
  })
}

/**
 * 查询用户个人信息
 * @returns
 */
export function getUserProfile() {
  return request({
    url: '/system/user/profile',
    method: 'get'
  })
}

/**
 * 修改用户个人信息
 * @param {any} data
 * @returns
 */
export function updateUserProfile(data) {
  return request({
    url: '/system/user/profile/edit',
    method: 'post',
    data: data
  })
}

/**
 * 用户密码重置
 * @param {string} oldPassword
 * @param {string} newPassword
 * @returns
 */
export function updateUserPwd(oldPassword, newPassword) {
  const data = {
    oldPassword,
    newPassword
  }
  return request({
    url: '/system/user/profile/updatePwd',
    method: 'post',
    params: data
  })
}

/**
 * 用户头像上传
 * @param {any} data
 * @returns
 */
export function uploadAvatar(data) {
  return request({
    headers: { 'Content-Type': 'mulipart/form-data' },
    url: '/system/user/profile/avatar',
    method: 'post',
    data: data
  })
}

/**
 * 查询授权角色
 * @param {string} userId
 * @returns
 */
export function getAuthRole(userId) {
  return request({
    url: '/system/user/authRole/' + userId,
    method: 'get'
  })
}

// 保存授权角色
export function updateAuthRole(data) {
  return request({
    url: '/system/user/authRole',
    method: 'post',
    params: data
  })
}

/**
 * 查询部门下拉树结构
 * @returns
 */
export function deptTreeSelect() {
  return request({
    url: '/system/user/deptTree',
    method: 'get'
  })
}

/**
 * 查询归属部门下拉树结构
 * @param {any} data
 * @returns
 */
export function selectDeptTreeListToComponent(data) {
  return request({
    url: '/system/dept/selectDeptTreeListToComponent',
    method: 'post',
    data: data
  })
}

/**
 * 查询岗位
 * @param {any} data
 * @returns
 */
export function selectPostToComponent(data) {
  return request({
    url: '/system/post/selectPostToComponent',
    method: 'POST',
    data: data
  })
}

/**
 * 查询角色
 * @param {any} data
 * @returns
 */
export function selectAllUserToComponent(data) {
  return request({
    url: '/system/user/selectAllUserToComponent',
    method: 'POST',
    data: data
  })
}

/**
 * 查询所属公司
 * @param {any} data
 * @returns
 */
export function queryCompanyList(data) {
  return request({
    url: '/system/companyInfo/queryCompanyList',
    method: 'POST',
    data: data
  })
}


/**
 * 查询所属公司
 * @param {any} data
 */
export function selectDeptNextEmployeesInfoTreeList(data) {
  return request({
    url: '/system/user/selectDeptNextEmployeesInfoTreeList',
    method: 'POST',
    data: data
  })
}

/**
 * 根据员工工号查询 表pm_employees 员工信息
 * @param {any} data
 */
export function selectEmployeesInfoByCode(data) {
  return request({
    url: '/system/user/selectEmployeesInfoByCode',
    method: 'POST',
    params: data
  })
}
