import request from '../../common/utils/request'

/**
 * 我的课程-课程列表
 * pageNum=1&pageSize=4&reason=1001
 * @param {{
*   pageNum: number
*   pageSize: number
*   trainType: number 课程类别
* }} data
* @returns
*/
export function myCourselist(data) {
  return request({
    url: '/train/TmTrainCourseMobile/myCourselist',
    method: 'get',
    params: data
  })
}


// 查询培训学习记录列表
export function listTmTrainRecord(query) {
  return request({
    url: '/train/TmTrainRecordMobile/list',
    method: 'get',
    params: query
  })
}


// 培训课程小节列表
export function listTmCourseSection(query) {
  return request({
    url: '/train/TmCourseSectionMobile/list',
    method: 'get',
    params: query
  })
}

// 培训课程小节详情
export function getTmCourseSection(id) {
  return request({
    url: '/train/TmCourseSectionMobile/' + id,
    method: 'get'
  })
}


// 新增培训学习记录
export function addTmTrainRecord(data) {
  return request({
    url: '/train/TmTrainRecord',
    method: 'post',
    data: data
  })
}

export function editTmTrainRecord(data) {
  return request({
    url: '/train/TmTrainRecord/edit',
    method: 'post',
    data: data
  })
}


// 获取培训视频线路列表
export function getStreamList(query) {
  return request({
    url: '/train/file/streamList',
    method: 'get',
    params: query
  })
}

export function publicCourselist(data) {
  return request({
    url: '/train/TmTrainCourseMobile/list',
    method: 'get',
    params: data
  })
}
