import request from '../common/utils/request'
import useUserStore from '@/store/modules/user'
import { getToken } from '../common/utils/auth'
/**
 * 获取验证码
 */
export function getCodeImg() {
  return request({
    url: '/code',
    headers: {
      isToken: false
    },
    method: 'get',
    timeout: 20000
  })
}
/**
 * 登录方法
 * @param {string} tenantId 租户id
 * @param {string} username 用户名
 * @param {string} password 密码
 * @param {string} code 验证码
 * @param {string} uuid uuid
 * @param {string} wxOpenId token
 */
export function login(params) {
  return request({
    url: '/auth/loginMobile',
    headers: {
      isToken: false
    },
    method: 'post',
    data: params
  })
}

/**
 * 微信授权码换openid
 * @param {string} code 微信授权码
 */
export function getUserToken(code) {
  return request({
    url: '/system/wechat/qyWechatUserIdByCode',
    method: 'get',
    params: { code: code }
  })
}

/**
 * 退出登录
 */
export function logout() {
  return request({
    url: '/auth/delete/logoutMobile',
    method: 'post'
  })
}

/**
 * 获取用户详细信息
 */
export function getInfo() {
  const userStore = useUserStore()
  return request({
    url: '/system/user/getMobileUserInfo',
    method: 'get',
    params: {
      wxUserId: userStore.token || getToken(),
      tenantId: '000000'
    }
  })
}

/**
 * 查询字典数据详细
 * @param {string} dictCode 字典码
 */
export function getData(dictCode) {
  return request({
    url: '/system/dict/data/' + dictCode,
    method: 'get'
  })
}

/**
 * 获取企业微信签名接口
 * @param {
 *   url: string
 * } query location.href
 * @returns
 */
export function getJsConfig(query) {
  return request({
    url: '/system/wechat/getJsConfig',
    method: 'post',
    params: query
  })
}

// 查询归属部门下拉树结构
export function selectDeptTreeListToComponent(data) {
  return request({
    url: '/system/dept/selectDeptTreeListToComponent',
    method: 'post',
    data: data
  })
}

// 查询岗位
export function selectPostToComponent(data) {
  return request({
    url: '/system/post/selectPostToComponent',
    method: 'POST',
    data: data
  })
}

/**
 * 修改密码
 * @param {string} userId 用户id
 * @param {string} oldPassword 旧密码
 * @param {string} password 新密码
 * @returns
 */
export function changePasswordSourceApp(data) {
  return request({
    url: '/system/user/changePasswordSourceApp',
    method: 'POST',
    data
  })
}

/**
 * 根据员工Code获取 员工详情信息
 * @param {string} employeeCode 用户code
 * @returns
 */
export function selectEmployeesDetailByCode(data) {
  return request({
    url: '/system/user/selectEmployeesDetailByCode',
    method: 'get',
    params: data
  })
}

/**
 * 工资条
 * @param {string} employeeCode 用户code
 * @returns
 */
export function getPersonalSalary(data) {
  return request({
    url: '/salary/planCalc/getPersonalSalary',
    method: 'GET',
    params: data
  })
}

/**
 * 我的绩效
 * @param {string} month 用户code
 * @returns
 */
export function getPersonalKpi(data) {
  return request({
    url: '/kpi/assess/getPersonalKpi',
    method: 'GET',
    params: data
  })
}