
const TokenKey = 'wxUserId'
const ExpiresInKey = 'Admin-Expires-In'
const AccessTokenKey = 'access_token'
const UserInfoKey = 'user_info'

// Token 操作
export function getToken() {
  return uni.getStorageSync(TokenKey)
}


export function setToken(token) {
  return new Promise((resolve) => {
    uni.setStorageSync(TokenKey, token)
    resolve(token)
  })
}


export function getAccessToken() {
  return uni.getStorageSync(AccessTokenKey)
}

export function setAccessToken(token) {
  return uni.setStorageSync(AccessTokenKey, token)
}

export function removeAccessToken() {
 return uni.removeStorageSync(AccessTokenKey)
}

export function removeToken() {
  uni.removeStorageSync(TokenKey)
}




export function getUserInfoAuth() {
  return uni.getStorageSync(UserInfoKey)
}

export function setUserInfo(userInfo) {
  return uni.setStorageSync(UserInfoKey, userInfo)
}

export function removeUserInfo() {
 return uni.removeStorageSync(UserInfoKey)
}








// 过期时间操作
export function getExpiresIn() {
  return uni.getStorageSync(ExpiresInKey) || -1
}

export function setExpiresIn(time) {
  uni.setStorageSync(ExpiresInKey, time)
}

export function removeExpiresIn() {
  uni.removeStorageSync(ExpiresInKey)
}
