const ua = navigator.userAgent

const isAndroid = /(Android);?[\s/]+([\d.]+)?/.test(ua)
const isIpad = /(iPad).*OS\s([\d_]+)/.test(ua)
const isIpod = /(iPod)(.*OS\s([\d_]+))?/.test(ua)
const isIphone = !isIpad && /(iPhone\sOS)\s([\d_]+)/.test(ua)
const isWechat = /micromessenger/i.test(ua)
const isAlipay = /alipayclient/i.test(ua)
const isApp = /taikangapp/i.test(ua)

const plugin = Vue => {
  if (!Vue.prototype.$device || !Vue.device) {
    Vue.prototype.$device = Vue.device = {
      isAndroid,
      isIpad,
      isIpod,
      isIphone,
      isWechat,
      isAlipay,
      isApp
    }
  }
}

export default plugin
export {
  isAndroid,
  isIpad,
  isIpod,
  isIphone,
  isWechat,
  isAlipay,
  isApp
}
