import request from '../../common/utils/request'

/**
 * 查询用车申请列表
 * pageNum=1&pageSize=4&employeesCode=1001
 * @param {{
 *   pageNum: number
 *   pageSize: number
 *   keyWord: number | string 搜索关键字
 * }} data
 * @returns
 */
export function getBusinessTAmCarApplylist(data) {
  return request({
    url: '/business/TAmCarApplyMobile/list',
    method: 'get',
    params: data
  })
}
// 查询车辆管理 列表
export function listTAmCarManageAll() {
  return request({
    url: '/business/TAmCarManageMobile/listAll',
    method: 'get'
  })
}

// 查询用车申请详细
export function getTAmCarApply(id) {
  return request({
    url: '/business/TAmCarApplyMobile/' + id,
    method: 'get'
  })
}


// 新增用车申请
export function addTAmCarApply(data) {
  return request({
    url: '/business/TAmCarApplyMobile',
    method: 'post',
    data: data
  })
}

// 修改用车申请
export function updateTAmCarApply(data) {
  return request({
    url: '/business/TAmCarApplyMobile/edit',
    method: 'post',
    data: data
  })
}
// 删除用车申请
export function delTAmCarApply(id) {
  return request({
    url: '/business/TAmCarApplyMobile/delete',
    method: 'post',
    data: id
  })
}
// 查询车辆油耗列表
export function listTAmCarOil(query) {
  return request({
    url: '/business/TAmCarOilMobile/list',
    method: 'get',
    params: query
  })
}
// 新增车辆油耗
export function insertTAmCarOilFileList(data) {
  return request({
    url: '/business/TAmCarOilMobile/insertTAmCarOilFileList',
    method: 'post',
    data: data
  })
}


// 查询车辆油耗详细
export function getTAmCarOil(id) {
  return request({
    url: '/business/TAmCarOilMobile/' + id,
    method: 'get'
  })
}


// 删除车辆油耗
export function delTAmCarOil(id) {
  return request({
    url: '/business/TAmCarOilMobile/delete',
    method: 'post',
    data: id
  })
}