
import request from '@/common/utils/request'

/**
 * 离职申请列表
 * @param {Object} data
 * @param {number} data.pageNum
 * @param {number} data.pageSize
 * @param {string} data.staffName 离职人
*/
export function resignationList(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/list',
    method: 'get',
    params: data
  })
}

/**
 * 离职申请详情
 * @param {string} id
*/
export function resignationDetail(id) {
  return request({
    url: '/personnelManagement/employeesDepartures/' + id,
    method: 'get'
  })
}


// 新增离职申请
export function addEmployeesDepartures(data) {
  return request({
    url: '/personnelManagement/employeesDepartures',
    method: 'post',
    data: data
  })
}

// 修改离职申请
export function updateEmployeesDepartures(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/edit',
    method: 'post',
    data: data
  })
}

// 离职申请apply
export function apply(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/apply',
    method: 'post',
    data: data
  })
}
