import request from '../../common/utils/request'

/**
 * 考勤-请假列表
 * pageNum=1&pageSize=4&reason=1001
 * @param {{
 *   pageNum: number
 *   pageSize: number
 *   reason: number | string 搜索关键字
 * }} data
 * @returns
 */
export function getLeaveRequestlist(data) {
  return request({
    url: '/attendance/attMobile/getLeaveRequestlist',
    method: 'get',
    params: data
  })
}

/**
 * 考勤-请假新增
 * @param {object} data 申请数据
 * @param {strgin} data.leaveType 请假类型
 * @param {strgin} data.backTime 开始时间
 * @param {strgin} data.endTime 结束时间
 * @param {strgin} data.duration 请假时长(小时)
 * @param {strgin} data.agentName 代理人
 * @param {strgin} data.reason 请假事由
 * @param {strgin} data.fileList 请假事由
 * @returns
 */
export function addLeaveRequest(data) {
  return request({
    url: '/attendance/attMobile/addLeaveRequest',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-请假新增
 * @param {object} data 申请数据
 * @param {strgin} data.id 请假类型
 * @param {strgin} data.auditStatus 1暂存 2审核中
 * @param {strgin} data.leaveType 请假类型
 * @param {strgin} data.backTime 开始时间
 * @param {strgin} data.endTime 结束时间
 * @param {strgin} data.duration 请假时长(小时)
 * @param {strgin} data.agentName 代理人
 * @param {strgin} data.reason 请假事由
 * @param {strgin} data.fileList 请假事由
 * @returns
 */
export function updateLeaveRequest(data) {
  return request({
    url: '/attendance/attMobile/updateLeaveRequest',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-销假申请
 * @param {{
 *   leaveRequestId: string
 *   backTime: string
 *   remark: string
 * }} data
 * @returns
 */
export function addLeaveRequestBack(data) {
  return request({
    url: '/attendance/attMobile/addLeaveRequestBack',
    method: 'post',
    data: data
  })
}

/**
 * 考勤-请假详情
 * @param {string} leaveRequestId id
 * @returns
 */
export function getLeaveRequestDetail(leaveRequestId) {
  return request({
    url: `/attendance/attMobile/getLeaveRequestDetail/${leaveRequestId}`,
    method: 'get'
  })
}

/**
 * 考勤-销假详情
 * @param {string} leaveRequestBackId id
 * @returns
 */
export function getLeaveRequrstBack(leaveRequestBackId) {
  return request({
    url: `/attendance/attMobile/getLeaveRequrstBack/${leaveRequestBackId}`,
    method: 'get'
  })
}

// 预计算请假天数（后端精确计算，按班次与节假日排除非工作日）
export function precomputeLeaveDays(params) {
  return request({
    url: '/attendance/leaveRequest/precompute',
    method: 'post',
    data: params
  })
}
export function getRestTime() {
  return request({
    url: '/attendance/leaveRequest/getRestTime',
    method: 'get'
  })
}