
import request from '../../common/utils/request'

/**
 * 宿舍评比列表
 * @param {Object} data
 * @param {number} data.pageNum
 * @param {number} data.pageSize
 * @param {string} data.staffName 离职人
*/
export function tAmRoomComparisonList(data) {
  return request({
    url: '/business/tAmRoomComparison/list',
    method: 'get',
    params: data
  })
}

/**
 * 新增宿舍评比
 * @param {Object} data
 * @param {string} data.comparisonBatch 评比批次
 * @param {string} data.comparisonDate 评比批次日期
 * @param {string} data.checkPeople 检查人
 * @param {string} data.checkAssistPeople 协助调查人
 * @param {string} data.checkPeopleId 检查人
 * @param {string} data.checkAssistPeopleId 协助调查人
 * @param {string} data.checkTime 检查时间
 * @param {string} data.remarks 备注
*/
export function insertTAmRoomComparisonAndDetailMobile(data) {
  return request({
    url: '/business/tAmRoomComparison/insertTAmRoomComparisonAndDetailMobile',
    method: 'post',
    data
  })
}

/**
 * 新增宿舍评比
 * @param {Object} data
 * @param {string} data.id 评比id
 * @param {string} data.comparisonBatch 评比批次
 * @param {string} data.comparisonDate 评比批次日期
 * @param {string} data.checkPeople 检查人
 * @param {string} data.checkAssistPeople 协助调查人
 * @param {string} data.checkPeopleId 检查人
 * @param {string} data.checkAssistPeopleId 协助调查人
 * @param {string} data.checkTime 检查时间
 * @param {string} data.remarks 备注
*/
export function tAmRoomComparisonEdit(data) {
  return request({
    url: '/business/tAmRoomComparison/edit',
    method: 'post',
    data
  })
}

/**
 * 查询评比详情
 * @param {string} comparisonId
*/
export function tAmRoomComparisonDetail(comparisonId) {
  return request({
    url: '/business/tAmRoomComparison/' + comparisonId,
    method: 'get'
  })
}

/**
 * 查询宿舍信息
 * @param {Object} data
 * @param {number} data.comparisonId
 * @param {number} data.status 已评1 未评0
*/
export function listByComparisonId(data) {
  return request({
    url: '/business/tAmRoomManage/listByComparisonId',
    method: 'get',
    params: data
  })
}

/**
 * 评比项数据
 * @param {Object} data
 * @param {number} data.pageNum
 * @param {number} data.pageSize
*/
export function tAmRoomTermList(data) {
  return request({
    url: '/business/tAmRoomTerm/list',
    method: 'get',
    params: data
  })
}

/**
 * 根据评比id、宿舍id查询评比明细
 * @param {Object} data
 * @param {string} data.comparisonId 评比id
 * @param {string} data.roomId 宿舍id
*/
export function listByMainAndRoomId(data) {
  return request({
    url: '/business/tAmRoomComparisonDetail/listByMainAndRoomId',
    method: 'get',
    params: data
  })
}

/**
 * 修改宿舍评比信息
 * @param {Array<Object>} data
 * @param {string} data.id
 * @param {string} data.comparisonId 评比id
 * @param {string} data.roomId 宿舍id
 * @param {string} data.roomNum 宿舍房间号
 * @param {string} data.roomCapacity 宿舍容量
 * @param {string} data.roomMargin 房间余量
 * @param {string} data.roomType 宿舍类型
 * @param {string} data.termId 检查项目ID
 * @param {string} data.termScore 项目得分
 * @param {string} data.termTotal 总分
 * @param {string} data.status 评比状态（1已评、0.未评）
*/
export function insertDetailList(data) {
  return request({
    url: '/business/tAmRoomComparisonDetail/insertDetailList',
    method: 'post',
    data
  })
}
