import request from '../common/utils/request'

/**
 * 消息 - 未读消息数量
 * @returns
 */
export function selectUserNotReadCount() {
  return request({
    url: '/system/notice/selectUserNotReadCount',
    method: 'get'
  })
}

/**
 * 消息 - 消息数量
 * @param {number} pageNum 页
 * @param {number} pageSize 大小
 * @param {string} type 1消息 2公告
 * @returns
 */
export function selectUserMsgList(data) {
  return request({
    url: '/system/notice/selectUserMsgList',
    method: 'get',
    params: data
  })
}

/**
 * 消息 - 已读
 * @param {string} id
 * @returns
 */
export function insertUserReadMsgInfo(data) {
  return request({
    url: '/system/notice/insertUserReadMsgInfo',
    method: 'POST',
    data
  })
}
