import request from '@/common/utils/request'

/**
 * 离职申请列表
 * @param {Object} data
 * @param {number} data.pageNum
 * @param {number} data.pageSize
 * @param {string} data.staffName 离职人
*/
export function handoverList(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/list',
    method: 'get',
    params: data
  })
}

// 查询离职申请列表
export function listEmployeesDepartures(query) {
  return request({
    url: '/personnelManagement/employeesDepartures/list',
    method: 'get',
    params: query
  })
}

// 查询离职申请详细
export function getEmployeesDepartures(id) {
  return request({
    url: '/personnelManagement/employeesDepartures/' + id,
    method: 'get'
  })
}

// 新增离职申请
export function addEmployeesDepartures(data) {
  return request({
    url: '/personnelManagement/employeesDepartures',
    method: 'post',
    data: data
  })
}

// 修改离职申请
export function updateEmployeesDepartures(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/edit',
    method: 'post',
    data: data
  })
}

// 删除离职申请
export function delEmployeesDepartures(id) {
  return request({
    url: '/personnelManagement/employeesDepartures/delete',
    method: 'post',
    data: id
  })
}

// 离职申请apply
export function apply(data) {
  return request({
    url: '/personnelManagement/employeesDepartures/apply',
    method: 'post',
    data: data
  })
}

// 离职工作交接项确认
export function confirmWorkHandoverItemConfirm(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/confirm',
    method: 'post',
    data: data
  })
}

// 转交工作交接项确认
export function transferWorkHandoverItemConfirm(data) {
  return request({
    url: '/personnelManagement/workHandoverItemConfirm/transfer',
    method: 'post',
    data: data
  })
}