
import request from '@/common/utils/request'

/**
 * 客户报餐计划-列表
 * pageNum=1&pageSize=4&reason=1001
 * @param {{
*   pageNum: number
*   pageSize: number
* }} data
* @returns
*/
export function TAmGuestReportPlanMobileList(data) {
  return request({
    url: '/business/TAmGuestReportPlanMobile/list',
    method: 'get',
    params: data
  })
}

/**
 * 新增客户报餐
 * @param data
 * @returns
 */
export function insertTAmGuestReportPlanInfo(data) {
  return request({
    url: '/business/TAmGuestReportPlanMobile/insertTAmGuestReportPlanInfo',
    method: 'post',
    data: data
  })
}

// 删除客人报餐计划
export function TAmGuestReportPlanMobile(id) {
  return request({
    url: '/business/TAmGuestReportPlanMobile/delete/' + id,
    method: 'post'
  })
}
/**
 * 餐品留样详情
 * @param id
 * @returns
 */
export function TAmGuestReportPlanMobileDetail(id) {
  return request({
    url: '/business/TAmGuestReportPlanMobile/' + id,
    method: 'get'
  })
}


