import request from '@/common/utils/request'

/**
 * 菜品留样-列表
 * pageNum=1&pageSize=4&reason=1001
 * @param {{
*   pageNum: number
*   pageSize: number
* }} data
* @returns
*/
export function tAmRetentionSampleMobileList(data) {
  return request({
    url: '/business/tAmRetentionSampleMobile/list',
    method: 'get',
    params: data
  })
}

// 查询餐品留样记录列表
export function listAllSpecifics(query) {
  return request({
    url: '/business/tAmMenuReleaseMobile/listAll',
    method: 'get',
    params: query
  })
}
// 新增餐品留样
export function insertRetentionSampleAndDetail(data) {
  return request({
    url: '/business/tAmRetentionSampleMobile/insertRetentionSampleAndDetail',
    method: 'post',
    data: data
  })
}
/**
 * 餐品留样详情
 * @param id
 * @returns
 */
export function tAmRetentionSampleMobileDetail(id) {
  return request({
    url: '/business/tAmRetentionSampleMobile/' + id,
    method: 'get'
  })
}

// 删除餐品留样记录
export function delTAmRetentionSample(id) {
  return request({
    url: '/business/tAmRetentionSample/delete/' + id,
    method: 'post'
  })
}


