import request from '@/common/utils/request'

/**
 * 员工报餐计划-列表
 * pageNum=1&pageSize=4&reason=1001
 * @param {{
*   pageNum: number
*   pageSize: number
* }} data
* @returns
*/
export function tAmEmployeeReportList(data) {
  return request({
    url: '/business/tAmEmployeeReportPlanMobile/list',
    method: 'get',
    params: data
  })
}

/**
 * 当前员工是否报餐
 * @param id 报餐id
 * @returns
 */
export function isReport(id) {
  return request({
    url: '/business/tAmEmployeeReportPlanMobile/' + id,
    method: 'get'
  })
}


/**
 * 详情
 * @param id 报餐id
 * @returns
 */
export function tAmEmployeeReportPlanMobiletail(data) {
  return request({
    url: '/business/tAmEmployeeReportPlanMobile/getDetailByInfo',
    method: 'post',
    data: data
  })
}


/**
 * 详情
 * @param id 报餐id
 * @returns
 */
export function insertTAmEmployeeReportPlan(data) {
  return request({
    url: '/business/tAmEmployeeReportPlanMobile/insertTAmEmployeeReportPlan',
    method: 'post',
    data: data
  })
}

