import { defineStore } from 'pinia'
import { selectUserNotReadCount } from '@/api/notice'
import { getTodoList } from '@/api/flowEngine/flowInterface'

export const useAppStore = defineStore('app', {
  
    state: () =>({
      appid: 'wxe7031284ca00a472',
      agentid: '1000006',
      unReadMessage: 0,
      todoCount: 0,
      API_PREFIX : 'https://demo.docmis.cn:21143/dl-prod-api'
                  // API_PREFIX: 'http://demo.docmis.cn:22880/prod-api',
    }),
    actions: {
      // 获取未读消息
      gettUserNotReadCount() {
        selectUserNotReadCount().then(res => {
          this.unReadMessage = res.data
        })
      },
      // 获取已办列表数量
      getFlowTodoList() {
        getTodoList({
          pageNum: 1,
          pageSize: 1
        }).then(res => {
          this.updateTodoCount(res.total)
        })
      },
      // 更新已办数量
      updateTodoCount(total) {
        this.todoCount = Number(total)
      }
    }
})