package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/dictionary"})
public class DictionaryController {
   @Autowired
   private DictionaryService dictionaryService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "console/dictionary";
   }

   @GetMapping({"/getDictinaryTypes"})
   @ResponseBody
   public Response getDictinaryTypes(@RequestBody(required = false) Map<String, Object> params) {
      List<ComboboxVO> list = new ArrayList();

      for(TConsoleDictionarytype type : this.dictionaryService.getDictinaryTypes()) {
         list.add(new ComboboxVO(type.getTypecode() + "", type.getTypename()));
      }

      return RespHelper.successResp(list);
   }

   @PostMapping({"/addDictionaryType"})
   @ResponseBody
   public Response addDictionaryType(@RequestBody(required = false) Map<String, Object> params) {
      TConsoleDictionarytype dictionaryType = null;
      if (null != params) {
         dictionaryType = (TConsoleDictionarytype)ObjectTool.getObjectByMap(TConsoleDictionarytype.class, (Map)params.get("dictionaryType"));
      } else {
         dictionaryType = new TConsoleDictionarytype();
         dictionaryType.setTypename("test分类");
         dictionaryType.setRemark("asfdasdf");
      }

      new HashMap();
      long typeCount = this.dictionaryService.queryDictionaryTypeCount(dictionaryType.getTypename());
      if (StringUtil.isBlank(dictionaryType.getId())) {
         ddmauditLogger.info(MesUtil.getMsg("DDM_00810", new String[]{CommonUtils.loginUsername(), dictionaryType.getTypename()}));
      } else {
         ddmauditLogger.info(MesUtil.getMsg("DDM_00811", new String[]{CommonUtils.loginUsername(), dictionaryType.getTypename()}));
      }

      this.dictionaryService.addDictionaryType(dictionaryType);
      return RespHelper.successResp();
   }

   @PostMapping({"/delDictionaryType"})
   @ResponseBody
   public Response delDictionaryType(@RequestBody(required = false) Map<String, Object> params) {
      List<String> idlist = new ArrayList();
      String dictionaryTypeCode = "";
      String dictionaryTypeName = "";
      if (null != params) {
         dictionaryTypeCode = (String)params.get("dictionaryTypeCode");
         dictionaryTypeName = (String)params.get("dictionaryTypeName");
      } else if (StringUtil.isBlank(dictionaryTypeCode)) {
         dictionaryTypeCode = "28";
         dictionaryTypeName = "402882eb70f190c80170f19b23e40002";
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_00812", new String[]{CommonUtils.loginUsername(), dictionaryTypeName}));
      idlist.add(dictionaryTypeCode);
      this.dictionaryService.removeDictionaryType(idlist);
      return RespHelper.successResp();
   }

   @PostMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody(required = false) Map<String, Object> params) {
      PageInfo pageInfo = new PageInfo();
      String typecode = "";
      String typename = "";
      if (null != params) {
         Integer page = (Integer)params.get("pageno");
         Integer rows = (Integer)params.get("pagesize");
         System.out.println();
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         pageInfo.setPageno(1);
         pageInfo.setPagesize(10);
         typecode = (String)params.get("typecode");
         typename = (String)params.get("typename");
      } else {
         pageInfo.setPageno(1);
         pageInfo.setPagesize(10);
         typecode = "21";
         typename = "test";
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_00813", new String[]{CommonUtils.loginUsername(), "code:" + typename}));
      List<TConsoleDictionary> list = this.dictionaryService.queryDictionaryByTypeCode(typecode, pageInfo, params);
      return RespHelper.updateResp(pageInfo, list);
   }

   @RequestMapping({"/add"})
   public void add(TConsoleDictionary dictionary, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dictionaryService.save(dictionary);
   }

   @RequestMapping({"/remove"})
   public void remove(@RequestParam("idlist[]") List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
   }
}
