package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.service.core.DgCommandRuleService;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/dbrulelog"})
public class DgCommandRuleController {
   private static Logger logger = LoggerFactory.getLogger(ControlledAssetController.class);
   @Autowired
   private DgCommandRuleService dgCommandRuleService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");

   @RequestMapping({"/queryAll"})
   @ResponseBody
   public Response query(@RequestParam Map<String, String> params, Integer pageno, Integer pagesize, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(pageno);
      pageInfo.setPagesize(pagesize);
      String ruletype = (String)params.get("ruletype");
      String createuser = (String)params.get("createuser");
      String datasourceid = (String)params.get("datasourceid");
      List<Map<String, Object>> list = this.dgCommandRuleService.queryAll(pageInfo, ruletype, createuser, datasourceid);
      return RespHelper.successResp(list, pageInfo.getCount().intValue());
   }
}
