package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.entity.orm.table.core.DgDefineRule;
import com.chenyang.nse.bussiness.service.core.DgDefinedRuleService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/core/definedrule"})
public class DgDefinedRuleController {
   @Autowired
   private DgDefinedRuleService definedRuleService;

   @RequestMapping({"/queryAll"})
   @ResponseBody
   public Response<List<DgDefineRule>> queryAll(@RequestBody Map<String, Object> map) {
      String type = map.get("type").toString();
      String user = map.get("user").toString();
      Integer page = (Integer)map.get("page");
      Integer everypage = (Integer)map.get("everypage");
      List<DgDefineRule> list;
      if (type.equals("全部")) {
         list = this.definedRuleService.queryAll(user);
      } else {
         list = this.definedRuleService.queryAll(type, user);
      }

      new ArrayList();
      List list1;
      if (list.size() < page * everypage) {
         list1 = list.subList((page - 1) * everypage, list.size());
      } else {
         list1 = list.subList((page - 1) * everypage, page * everypage);
      }

      return RespHelper.<List<DgDefineRule>>successResp(list1, list.size());
   }

   @RequestMapping({"/queryLogByProjectId"})
   @ResponseBody
   public Response<List<DgDefineRule>> queryLogByProjectId(@RequestBody Map<String, Object> map) {
      String projectid = map.get("projectid").toString();
      List<DgDefineRule> list = this.definedRuleService.queryLogByProjectId(projectid);
      return RespHelper.<List<DgDefineRule>>successResp(list, list.size());
   }
}
