package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataTargetfield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.redis.DmpTransTask;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableSchema;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DmpDesensitizationService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.service.info.db.DatabaseTool;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.http.HttpUtils;
import com.chenyang.nse.bussiness.tools.http.JacksonUtils;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.redis.RedisClient;
import com.chenyang.nse.bussiness.tools.redis.RedisTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.system.SysUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import redis.clients.jedis.Jedis;
import transdbf.transdbf;

@EnableAsync
@Controller
@RequestMapping({"/core/dmpdesensitization"})
public class DmpDesensitizationController {
   private static Logger logger = LoggerFactory.getLogger(DesensitizationController.class);
   private static final String Link_character = "_";
   public static final String DB_pwc_FILE_batchwrite_DB = "DBtoDB,normal,batchwrite";
   public static final String DB_batchread_FILE_pwc_DB = "DBtoDB,batchread,normal";
   public static final String DB_batchread_FILE_pwc_FILE_batchwrite_DB = "DBtoDB,batchread,batchwrite";
   public static final String DB_pwc_DB = "DBtoDB,normal,normal";
   public static final String DB_pwc_FILE = "DBtoFILE,normal";
   public static final String DB_batchread_FILE_pwc_FILE = "DBtoFILE,batchread";
   public static final String FILE_pwc_FILE_batchwrite_DB = "FILEtoDB,batchwrite";
   public static final String FILE_pwc_DB = "FILEtoDB,normal";
   public static final String FILE_pwc_FILE = "FILEtoFILE";
   public static final String HIVE_batchread_FILE_pwc_FILE_batchwrite_HIVE = "HIVEtoHIVE,batchread,batchwrite";
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private DmpDesensitizationService dmpDesensitizationService;
   @Autowired
   private InfoService infoService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private HttpServletRequest request;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/desensitizationtaskdmp/desensitizationtasklist";
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<Desensitizationtask> querytask(String isstart, String engineid, String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      RedisClient redisClient = null;
      Jedis jedis = null;
      if (isstart != null) {
         redisClient = new RedisClient();
         jedis = redisClient.getJedis();
      }

      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Desensitizationtask> list = this.dmpDesensitizationService.queryTask(taskname, pageInfo);
      if (isstart != null) {
         for(Desensitizationtask desensitizationtask : list) {
            String tasknamereal = desensitizationtask.getTasknamereal();
            if (!desensitizationtask.getSave_state().equals("0")) {
               if (desensitizationtask.getSave_state().equals("1")) {
                  desensitizationtask.setCount_exe("");
               } else {
                  desensitizationtask.setCount_exe("100%");
               }

               jedis.del(tasknamereal + "_zcount");
               jedis.del(tasknamereal + "_ncount");
            } else {
               jedis.get(tasknamereal + "_ntime");
               String count_exe = jedis.get(tasknamereal + "_zcount");
               String ncount_exe = jedis.get(tasknamereal + "_ncount");
               long ncount_exe_num = 0L;
               long count_exe_num = 1L;

               try {
                  if (ncount_exe == null) {
                     ncount_exe = "0";
                  }

                  if (count_exe == null) {
                     count_exe = "1";
                  }

                  ncount_exe_num = new Long(ncount_exe);
                  count_exe_num = new Long(count_exe);
               } catch (Exception var25) {
               }

               NumberFormat numberFormat = NumberFormat.getInstance();
               numberFormat.setMaximumFractionDigits(2);
               String result = numberFormat.format((double)ncount_exe_num / (double)count_exe_num * (double)100.0F);
               desensitizationtask.setCount_exe(result + "%");
            }
         }

         jedis.close();
      }

      DataGridVO<Desensitizationtask> vo = new DataGridVO<Desensitizationtask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String taskid, String step, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      map.put("tasknamereal", (String)this.request.getSession().getAttribute("tasknamereal"));
      if (step == null) {
         step = (String)this.request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         this.request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "desensitizationtask_one":
            this.desensitizationtask_one(map, model);
            break;
         case "desensitizationtask_two":
            this.desensitizationtask_two(map, model);
            break;
         case "desensitizationtask_two_file":
            this.desensitizationtask_two_file(map, model);
            break;
         case "desensitizationtask_three":
            this.desensitizationtask_three(map, model);
            break;
         case "desensitizationtask_four":
            this.desensitizationtask_four(map, model);
            break;
         case "desensitizationtask_five":
            this.request.getSession().setAttribute("page_five", map.get("pageparam"));
      }

      return "core/desensitizationtaskdmp/" + step;
   }

   @RequestMapping({"/querydatasystem"})
   @ResponseBody
   public List<TCoreDatasystem> querydatasystem(String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> flag = new ArrayList();
      if (type != null && !"".equals(type)) {
         flag.add(type);
      } else {
         flag.add("1");
      }

      List<TCoreDatasystem> list = this.dataSystemService.query(flag, "ORACLE");
      return list;
   }

   @RequestMapping({"/exportway"})
   @ResponseBody
   public String exportway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ExportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/importway"})
   @ResponseBody
   public String importway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ImportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/targetparam"})
   @ResponseBody
   public Map<String, String> targetparam(String database, String execution_type, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      Map<String, String> targetparam = new HashMap();
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         if (execution_type.equals("normal")) {
            targetparam = base.TargetParameter_normal();
         } else {
            targetparam = base.TargetParameter_notNormal();
         }
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return targetparam;
   }

   public void desensitizationtask_one(Map<String, String> map, Model model) {
      String newtask = (String)map.get("newtask");
      String tasknamereal = (String)map.get("tasknamereal");
      if (newtask != null) {
         model.addAttribute("state", "checked");
      } else {
         RedisClient redisClient = new RedisClient();
         Desensitizationtask desensitizationtask = new Desensitizationtask();
         Jedis jedis = redisClient.getJedis();
         byte[] byt = jedis.get((tasknamereal + "_" + desensitizationtask.getClass().getSimpleName()).getBytes());
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            desensitizationtask = (Desensitizationtask)obj;
         }

         model.addAttribute("taskname", desensitizationtask.getTaskname());
         model.addAttribute("folder", desensitizationtask.getFoldername());
         model.addAttribute("tasknote", desensitizationtask.getRemark());
         model.addAttribute("isrecover", desensitizationtask.getIsrecover());
         model.addAttribute("dmppath", desensitizationtask.getDmppath());
         model.addAttribute("charsettype", desensitizationtask.getDmpcharset());
         model.addAttribute("state", desensitizationtask.getFastexecution() != null && desensitizationtask.getFastexecution().equals("1") ? "checked" : "");
      }

   }

   @RequestMapping({"/requestparsedmpfile"})
   @ResponseBody
   public Map<String, Object> reqParseDmpFile(HttpServletRequest request, HttpServletResponse response, String taskname, String dmppath, String charsetFull) {
      Map<String, Object> resultMap = new HashMap();
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
      String tasknamereal = stamp + "_" + StringTool.hanziToPinyinFirst(taskname);
      request.getSession().setAttribute("tasknamereal", tasknamereal);
      resultMap.put("tasknamereal", tasknamereal);
      new Properties();
      String apiType = "parseFile";

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String url = props.getProperty("parse_dmp_file_url");
         String exp_path = props.getProperty("dmp_exp_path");
         String separator = props.getProperty("dmp_separator");
         String line_feed = props.getProperty("dmp_line_feed");
         String enclose = props.getProperty("dmp_enclose");
         String suffix = props.getProperty("dmp_suffix");
         Map<String, String> mapParams = new HashMap();
         mapParams.put("name", tasknamereal);
         mapParams.put("file_path", "/data/infa_dmp/" + dmppath);
         mapParams.put("exp_path", exp_path);
         mapParams.put("separator", separator);
         mapParams.put("line_feed", line_feed);
         mapParams.put("enclose", enclose);
         mapParams.put("charset", charsetFull);
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         desensitizationfile.setFiletype(Integer.parseInt("0"));
         desensitizationfile.setFiledir(exp_path);
         desensitizationfile.setCodepage(charsetFull.indexOf("UTF8") != -1 ? "0" : "1");
         desensitizationfile.setSuffix(suffix);
         desensitizationfile.setDateformat("YYYY-MM-DD HH24:MI:SS");
         desensitizationfile.setDelimiters(separator);
         desensitizationfile.setQuotecharacter("double");
         jedis.set(("dmpTransTask" + tasknamereal + "_" + desensitizationfile.getClass().getSimpleName()).getBytes(), RedisTool.serialize(desensitizationfile));
         String respVal = HttpUtils.requestFor(mapParams, apiType, url);
         Map<String, Object> mapRtn = (Map<String, Object>) JacksonUtils.parseJsonToMap(respVal);
         if (mapRtn != null && (Integer)mapRtn.get("code") == 0) {
            Map<String, Object> dataMap = (Map)mapRtn.get("data");
            DmpTransTask dmpTransTask = new DmpTransTask();
            dmpTransTask.setJob_id((Integer)dataMap.get("job_id"));
            dmpTransTask.setTaskname(tasknamereal);
            jedis.set(("dmpTransTask" + tasknamereal).getBytes(), RedisTool.serialize(dmpTransTask));
            resultMap.put("message", "SUCCESS");
         } else {
            resultMap.put("message", "PARSE ERROR");
         }

         jedis.close();
         return resultMap;
      } catch (IOException e) {
         jedis.close();
         e.printStackTrace();
         resultMap.put("message", "FAIL EXCEPTION");
         return resultMap;
      }
   }

   @RequestMapping(
      value = {"/testpost"},
      produces = {"application/json;charset=UTF-8"}
   )
   @ResponseBody
   public Map<String, Object> testpost(HttpServletRequest request, HttpServletResponse response, String name, String file_path, String exp_path, String separator, String line_feed, String enclose, String charset) {
      new HashMap();
      String str = "{\"code\": 0,\"data\": {\"job_id\": 1070},\"message\": \"操作成功\"}";
      Map<String, Object> map = (Map<String, Object>) JacksonUtils.parseJsonToMap(str);
      return map;
   }

   @RequestMapping({"/getparseprogress"})
   @ResponseBody
   public Map<String, Object> getParseProgress(HttpServletRequest request, HttpServletResponse response) {
      Map<String, Object> resultMap = new HashMap();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String apiType = null;
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String url = props.getProperty("parse_dmp_get_progress");
         byte[] byt = jedis.get(("dmpTransTask" + tasknamereal).getBytes());
         new DmpTransTask();
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            DmpTransTask dmpTransTask = (DmpTransTask)obj;
            Map<String, String> mapParams = new HashMap();
            mapParams.put("job_id", dmpTransTask.getJob_id() + "");
            mapParams.put("page", "1");
            mapParams.put("page_size", "10000");
            String respVal = HttpUtils.requestFor(mapParams, apiType, url);
            Map<String, Object> mapRtn = (Map<String, Object>) JacksonUtils.parseJsonToMap(respVal);
            int code = (Integer)mapRtn.get("code");
            if (mapRtn != null && code == 0) {
               JSONObject jsonData = new JSONObject(mapRtn);
               JSONArray arrData = jsonData.getJSONArray("data");
               Iterator var19 = arrData.iterator();
               if (var19.hasNext()) {
                  Object percentageObj = var19.next();
                  Map<String, Object> dataMap = (Map)percentageObj;
                  resultMap.put("percentage", dataMap.get("percentage"));
                  resultMap.put("message", "SUCCESS");
               }
            } else {
               resultMap.put("message", (String)mapRtn.get("message"));
            }
         } else {
            resultMap.put("message", "redis 异常！");
         }

         jedis.close();
      } catch (IOException e) {
         jedis.close();
         e.printStackTrace();
         resultMap.put("message", "FAIL EXCEPTION");
      }

      return resultMap;
   }

   @RequestMapping(
      value = {"/testget1"},
      produces = {"application/json;charset=UTF-8"}
   )
   @ResponseBody
   public Map<String, Object> testget1(HttpServletRequest request, HttpServletResponse response, String job_id) {
      new HashMap();
      String str = "{\"code\": 0,\"data\": [{\"exp_path\": \"/home/duni/exp_data\",\"file_path\": \"/home/duni/testshow3.dmp\",\"job_id\": 999,\"message\": \"\",\"name\": \"TEST_003\",\"percentage\": 100,\"status\": \"completed\",\"tag\": \"DMP2CSV\"}],\"message\": \"操作成功\"}";
      Map<String, Object> map = (Map<String, Object>) JacksonUtils.parseJsonToMap(str);
      return map;
   }

   @RequestMapping({"/gettableinfostructure"})
   @ResponseBody
   public Map<String, String> getTableInfoStructure(HttpServletRequest request, HttpServletResponse response) throws InterruptedException {
      Map<String, String> resultMap = new HashMap();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String url = props.getProperty("parse_dmp_get_tableinfo");
         Map<String, String> mapParams = new HashMap();
         mapParams.put("name", tasknamereal);
         mapParams.put("page", "1");
         mapParams.put("page_size", "10000");
         String respVal = HttpUtils.requestFor(mapParams, (String)null, url);
         System.out.println("============11111respVal=" + respVal);
         if (respVal == null) {
            resultMap.put("message", "GET INFO ERROR");
         } else {
            Map<String, Object> mapRtn = (Map<String, Object>) JacksonUtils.parseJsonToMap(respVal);
            if ((Integer)mapRtn.get("code") != 0) {
               resultMap.put("message", (String)mapRtn.get("message"));
            } else {
               JSONObject jsonData = new JSONObject(mapRtn);
               List<TCoreMaskingTaskTableSchema> tCoreMaskingTaskTableSchemaList = new ArrayList();

               for(Object obj_d : jsonData.getJSONArray("data")) {
                  Map<String, Object> mapSchema = (Map)obj_d;
                  TCoreMaskingTaskTableSchema tCoreMaskingTaskTableSchema = new TCoreMaskingTaskTableSchema();
                  tCoreMaskingTaskTableSchema.setSchema((String)mapSchema.get("schema_name"));
                  JSONObject jsonTable = new JSONObject(mapSchema);
                  JSONArray jsonArrSchema = jsonTable.getJSONArray("tables");
                  List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

                  for(Object obj_s : jsonArrSchema) {
                     Map<String, Object> maptable = (Map)obj_s;
                     JSONObject jsonColumn = new JSONObject(maptable);

                     for(Object obj_c : jsonColumn.getJSONArray("column")) {
                        Map<String, Object> mapColumn = (Map)obj_c;
                        TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
                        tCoreMaskingTaskTableInfo.setColumnName((String)mapColumn.get("column_name"));
                        tCoreMaskingTaskTableInfo.setSourceType((String)mapColumn.get("column_type"));
                        tCoreMaskingTaskTableInfo.setColumnLength((Integer)mapColumn.get("length") + "");
                        tCoreMaskingTaskTableInfo.setColumnPrecision((Integer)mapColumn.get("scale") + "");
                        tCoreMaskingTaskTableInfo.setRemark((String)mapColumn.get("comments"));
                        tCoreMaskingTaskTableInfo.setTableName((String)maptable.get("table_name"));
                        tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
                     }

                     tCoreMaskingTaskTableSchema.settCoreMaskingTaskTableInfoList(tCoreMaskingTaskTableInfoList);
                  }

                  tCoreMaskingTaskTableSchemaList.add(tCoreMaskingTaskTableSchema);
               }

               jedis.set(("dmpTransTask_Info_" + tasknamereal).getBytes(), RedisTool.serialize(tCoreMaskingTaskTableSchemaList));
               resultMap.put("message", "SUCCESS");
            }
         }

         jedis.close();
      } catch (Exception e) {
         jedis.close();
         e.printStackTrace();
         resultMap.put("message", "FAIL EXCEPTION");
      }

      return resultMap;
   }

   @RequestMapping(
      value = {"/testget2"},
      produces = {"application/json;charset=UTF-8"}
   )
   @ResponseBody
   public Map<String, Object> testget2(HttpServletRequest request, HttpServletResponse response, String name, Integer page, Integer page_size) {
      new HashMap();
      String str = "{\"code\":0,\"data\":[{\"schema_name\":\"TEST_IMP\",\"tables\":[{\"column\":[{\"column_name\":\"id\",\"column_type\":\"NUMBER\",\"comments\":\"\",\"foreign_key\":false,\"length\":22,\"primary_key\":true,\"scale\":0}],\"table_name\":\"HH\"},{\"column\":[{\"column_name\":\"ID\",\"column_type\":\"NUMBER\",\"comments\":\"\",\"foreign_key\":false,\"length\":22,\"primary_key\":false,\"scale\":0},{\"column_name\":\"NAME\",\"column_type\":\"VARCHAR2\",\"comments\":\"\",\"foreign_key\":false,\"length\":20,\"primary_key\":false,\"scale\":0}],\"table_name\":\"TEST\"}]}],\"message\":\"操作成功\",\"page\":1,\"page_size\":20,\"total\":1,\"total_page\":1}";
      Map<String, Object> map = (Map<String, Object>) JacksonUtils.parseJsonToMap(str);
      return map;
   }

   public void desensitizationtask_two(Map<String, String> map, Model model) {
      RedisClient redisClient = new RedisClient();
      Desensitizationtask desensitizationtask = new Desensitizationtask();
      Jedis jedis = redisClient.getJedis();
      if (((String)map.get("way")).equals("prev")) {
         String tasknamereal = (String)map.get("tasknamereal");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         byte[] byt = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            desensitizationsource = (Desensitizationsource)obj;
         }

         model.addAttribute("dataschema", desensitizationsource.getDataschema());
         model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
         model.addAttribute("execution_type", desensitizationsource.getExecution_type());
         String hadoop = (String)this.request.getSession().getAttribute("hadoop_s");
         if ("1".equals(hadoop)) {
            model.addAttribute("hadoop", "1");
         } else {
            model.addAttribute("hadoop", "0");
         }

         desensitizationtask.setTasknamereal(tasknamereal);
      } else if (((String)map.get("way")).equals("next")) {
         desensitizationtask.setIsrecover(map.get("isrecover") == null ? "0" : (String)map.get("isrecover"));
         desensitizationtask.setFastexecution((String)map.get("isfast"));
         desensitizationtask.setFoldername((String)map.get("folder"));
         desensitizationtask.setTaskname((String)map.get("taskname"));
         desensitizationtask.setUserid((String)map.get("userid"));
         desensitizationtask.setUsername((String)map.get("username"));
         String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
         desensitizationtask.setRemark((String)map.get("tasknote"));
         desensitizationtask.setStamp(stamp);
         desensitizationtask.setTasknamereal(stamp + "_" + StringTool.hanziToPinyinFirst((String)map.get("taskname")));
         jedis.set((desensitizationtask.getTasknamereal() + "_" + desensitizationtask.getClass().getSimpleName()).getBytes(), RedisTool.serialize(desensitizationtask));
         this.request.getSession().setAttribute("isrecoverState", map.get("isrecover") == null ? "0" : map.get("isrecover"));
      } else if ("1".equals(map.get("hadoop"))) {
         model.addAttribute("hadoop", map.get("hadoop"));
         this.request.getSession().setAttribute("hadoop_s", "1");
      } else {
         model.addAttribute("hadoop", "0");
         this.request.getSession().setAttribute("hadoop_s", "0");
      }

   }

   public void desensitizationtask_two_file(Map<String, String> map, Model model) {
      RedisClient redisClient = new RedisClient();
      Desensitizationtask desensitizationtask = new Desensitizationtask();
      Jedis jedis = redisClient.getJedis();
      if (((String)map.get("way")).equals("prev")) {
         String tasknamereal = (String)map.get("tasknamereal");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         byte[] byt = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            desensitizationsource = (Desensitizationsource)obj;
         }

         String datasourceid = desensitizationsource.getDatasourceid();
         String filesystemlocation = "";
         if (datasourceid != null && !datasourceid.equals("")) {
            TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
            String dbtype = tCoreDatasystem.getDbtype();
            if (dbtype.equals("FTP")) {
               filesystemlocation = "1";
            } else if (dbtype.equals("SFTP")) {
               filesystemlocation = "2";
            }
         } else {
            filesystemlocation = "0";
         }

         model.addAttribute("filesystemid", desensitizationsource.getDataschema());
         model.addAttribute("filesystemlocation", filesystemlocation);
         model.addAttribute("sourcefiledir", desensitizationsource.getSourcefiledir());
         model.addAttribute("datasourceid", datasourceid);
         desensitizationtask.setTasknamereal(tasknamereal);
      } else if (((String)map.get("way")).equals("next")) {
         desensitizationtask.setFastexecution((String)map.get("isfast"));
         desensitizationtask.setFoldername((String)map.get("folder"));
         desensitizationtask.setTaskname((String)map.get("taskname"));
         desensitizationtask.setUserid((String)map.get("userid"));
         desensitizationtask.setUsername((String)map.get("username"));
         String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
         desensitizationtask.setRemark((String)map.get("tasknote"));
         desensitizationtask.setStamp(stamp);
         desensitizationtask.setTasknamereal(stamp + "_" + StringTool.hanziToPinyinFirst((String)map.get("taskname")));
         jedis.set((desensitizationtask.getTasknamereal() + "_" + desensitizationtask.getClass().getSimpleName()).getBytes(), RedisTool.serialize(desensitizationtask));
         this.request.getSession().setAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      }

   }

   public void desensitizationtask_three(Map<String, String> map, Model model) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         byte[] byt = jedis.get((tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName()).getBytes());
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            desensitizationtarget = (Desensitizationtarget)obj;
         }

         model.addAttribute("dataschema", desensitizationtarget.getDataschema());
         model.addAttribute("datasourceid", desensitizationtarget.getDatasourceid());
         model.addAttribute("execution_type", desensitizationtarget.getExecution_type());
         model.addAttribute("inserttype", desensitizationtarget.getInserttype());
         model.addAttribute("isclear", desensitizationtarget.getIsclear());
         model.addAttribute("isindex", desensitizationtarget.getIsindex());
         model.addAttribute("isprimary", desensitizationtarget.getIsprimary());
         model.addAttribute("isrebuild", desensitizationtarget.getIsrebuild());
         model.addAttribute("loadscripttype", desensitizationtarget.getLoadscripttype());
         model.addAttribute("tasknamereal", tasknamereal);
         String hadoop = (String)this.request.getSession().getAttribute("hadoop_t");
         if ("1".equals(hadoop)) {
            model.addAttribute("hadoop", "1");
         } else {
            model.addAttribute("hadoop", "0");
         }
      } else if (((String)map.get("way")).equals("next")) {
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource.setDataschema((String)map.get("filesystemid"));
         if ("1".equals(map.get("filesystemlocation"))) {
            String filesystemftp = (String)map.get("filesystemftp");
            desensitizationsource.setDatasourceid(filesystemftp);
         } else if ("2".equals(map.get("filesystemlocation"))) {
            String filesystemsftp = (String)map.get("filesystemsftp");
            desensitizationsource.setDatasourceid(filesystemsftp);
         }

         String stamp = tasknamereal.substring(0, tasknamereal.indexOf("_"));
         Desensitizationtask desensitizationtask = new Desensitizationtask();
         desensitizationtask.setIsrecover(map.get("isrecover") == null ? "0" : (String)map.get("isrecover"));
         desensitizationtask.setFastexecution((String)map.get("isfast"));
         desensitizationtask.setFoldername((String)map.get("folder"));
         desensitizationtask.setTaskname((String)map.get("taskname"));
         desensitizationtask.setUserid((String)map.get("userid"));
         desensitizationtask.setUsername((String)map.get("username"));
         desensitizationtask.setRemark((String)map.get("tasknote"));
         desensitizationtask.setDmppath((String)map.get("dmppath"));
         desensitizationtask.setDmpcharset((String)map.get("charsettype"));
         desensitizationtask.setStamp(stamp);
         desensitizationtask.setTasknamereal(tasknamereal);
         jedis.set((desensitizationtask.getTasknamereal() + "_" + desensitizationtask.getClass().getSimpleName()).getBytes(), RedisTool.serialize(desensitizationtask));
         this.request.getSession().setAttribute("isrecoverState", map.get("isrecover") == null ? "0" : map.get("isrecover"));
         model.addAttribute("isrebuild", "isrebuild");
         model.addAttribute("isclear", "isclear");
         model.addAttribute("tasknamestamp", map.get("tasknamestamp"));
         desensitizationsource.setExecution_type("normal");
         desensitizationsource.setSourcefiledir((String)map.get("sourcefiledir"));
         jedis.set((desensitizationtask.getTasknamereal() + "_" + desensitizationsource.getClass().getSimpleName()).getBytes(), RedisTool.serialize(desensitizationsource));
      } else {
         model.addAttribute("isrebuild", "isrebuild");
         model.addAttribute("isclear", "isclear");
         if ("1".equals(map.get("hadoop"))) {
            model.addAttribute("hadoop", map.get("hadoop"));
            this.request.getSession().setAttribute("hadoop_t", "1");
         } else {
            model.addAttribute("hadoop", "0");
            this.request.getSession().setAttribute("hadoop_t", "0");
         }
      }

   }

   public void desensitizationtask_four(Map<String, String> map, Model model) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         model.addAttribute("way", "prev");
         byte[] sourceByte = jedis.get((tasknamereal + "_" + "Desensitizationsource").getBytes());
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         if (sourceByte != null) {
            desensitizationsource = (Desensitizationsource)RedisTool.unserizlize(sourceByte);
            model.addAttribute("group", desensitizationsource.getDataschema());
         }

         byte[] targetByte = jedis.get((tasknamereal + "_" + "Desensitizationtarget").getBytes());
         Desensitizationtarget desensitizationtarget2 = new Desensitizationtarget();
         if (targetByte != null) {
            desensitizationtarget2 = (Desensitizationtarget)RedisTool.unserizlize(targetByte);
            model.addAttribute("group", desensitizationtarget2.getDataschema());
         }

         if (desensitizationsource.getDatasourceid() != null && !desensitizationsource.getDatasourceid().equals("")) {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget2.getDatasourceid());
            if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
               model.addAttribute("mappingEditFlag", "dbsystem_diff");
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         model.addAttribute("isshow", "1");
      } else if (((String)map.get("way")).equals("next")) {
         Map<String, String> filterMap = new HashMap();
         this.request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", filterMap);
         byte[] sourceByte = jedis.get((tasknamereal + "_" + "Desensitizationsource").getBytes());
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         if (sourceByte != null) {
            desensitizationsource = (Desensitizationsource)RedisTool.unserizlize(sourceByte);
         }

         if (((String)map.get("s-systemtype")).equals("0")) {
            List<Map<String, String>> tableList = new ArrayList();
            byte[] bs = jedis.get(("dmpTransTask_Info_" + (String)map.get("tasknamereal")).getBytes());
            new ArrayList();
            if (bs != null) {
               List<TCoreMaskingTaskTableSchema> var27 = (List)RedisTool.unserizlize(bs);
               String schema = null;

               for(TCoreMaskingTaskTableSchema tCoreMaskingTaskTableSchema : var27) {
                  Map<String, String> mapTemp = new HashMap();
                  schema = tCoreMaskingTaskTableSchema.getSchema();

                  for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableSchema.gettCoreMaskingTaskTableInfoList()) {
                     mapTemp.put(tCoreMaskingTaskTableInfo.getTableName(), "0");
                     System.out.println("tableName=" + tCoreMaskingTaskTableInfo.getTableName());
                  }

                  for(String key : mapTemp.keySet()) {
                     Map<String, String> tableMap = new HashMap();
                     tableMap.put("tableName", schema + "-" + key);
                     tableMap.put("status", "0");
                     tableList.add(tableMap);
                  }
               }
            }

            this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
            Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
            desensitizationtarget.setDataschema((String)map.get("dataschema"));
            desensitizationtarget.setDatasourceid((String)map.get("datasourceid"));
            desensitizationtarget.setExecution_type((String)map.get("execution_type"));
            desensitizationtarget.setInserttype((String)map.get("inserttype"));
            desensitizationtarget.setIsclear((String)map.get("isclear"));
            desensitizationtarget.setIsindex((String)map.get("isindex"));
            desensitizationtarget.setIsprimary((String)map.get("isprimary"));
            desensitizationtarget.setIsrebuild((String)map.get("isrebuild"));
            desensitizationtarget.setLoadscripttype((String)map.get("loadscripttype"));
            jedis.set((tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName()).getBytes(), RedisTool.serialize(desensitizationtarget));
            if (desensitizationsource.getDatasourceid() != null && !desensitizationsource.getDatasourceid().equals("")) {
               TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
               TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("datasourceid"));
               if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
                  model.addAttribute("mappingEditFlag", "dbsystem_diff");
               } else {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               }
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }

            model.addAttribute("tasknamestamp", map.get("tasknamestamp"));
         }

         model.addAttribute("isshow", "0");
      }

      jedis.close();
   }

   private void batchDel(Jedis jedis, String key) {
      for(String keyStr : jedis.keys(key + "*")) {
         System.out.println(keyStr);
         jedis.del(keyStr);
      }

   }

   @RequestMapping({"/querytasktype"})
   @ResponseBody
   public List<ComboboxVO> querytasktype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();

      for(EmaskingTaskType e : EmaskingTaskType.values()) {
         ComboboxVO c = new ComboboxVO(e.getFlag(), e.getMaskingtype());
         list.add(c);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryfolder"})
   public List<Map<String, String>> queryfolder(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> folder = this.infoService.queryFolderList(engineid);
      List<Map<String, String>> list = new ArrayList();

      for(String item : folder) {
         Map<String, String> map = new HashMap();
         map.put("id", item);
         map.put("text", item);
         map.put("iconCls", "icon-folder");
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroups"})
   public List<ComboboxVO> querysensitivegroups(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.searchRegexService.querySensitiveGroups();
   }

   @RequestMapping({"/executepubtask"})
   public String executepubtask(String taskid, String engineid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      if ("1".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorrun";
      } else if ("2".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorimptask";
      } else if ("3".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorsubtask";
      } else {
         return "";
      }
   }

   @ResponseBody
   @RequestMapping({"/savetask"})
   public Map<String, String> savetask(HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Map<String, String> map = new HashMap();
      if (tasknamereal == null) {
         map.put("state", "1");
      } else {
         String taskid = this.dmpDesensitizationService.gettaskBytasknamereal(tasknamereal);
         map.put("state", taskid);
      }

      return map;
   }

   @RequestMapping({"/savetask_info"})
   public String savetask_info(String state, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Map<String, Object> map = new HashMap();
      Object obj = request.getSession().getAttribute("loginUser");
      Map<String, String> map_table_filterConditions = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
      map.put("state", state);
      map.put("loginUser", obj);
      map.put("map_table_filterConditions", map_table_filterConditions);
      map.put("tableList", request.getSession().getAttribute("tableList_" + tasknamereal));
      if (!state.equals("1")) {
         this.dmpDesensitizationService.savetask_info(tasknamereal, map);
      }

      request.getSession().removeAttribute("tableList_" + tasknamereal);
      request.getSession().removeAttribute("tasknamereal");
      return "core/desensitizationtaskdmp/desensitizationtasklist";
   }

   @ResponseBody
   @RequestMapping({"/querytaskdetail"})
   public Map<String, Object> querytaskdetail(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      if (taskid != null && !taskid.equals("")) {
         tasknamereal = "";
      }

      Map<String, Object> map = new HashMap();
      RedisClient redisClient = new RedisClient();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtask desensitizationtask = new Desensitizationtask();
      Jedis jedis = redisClient.getJedis();
      byte[] byt_task = jedis.get((tasknamereal + "_" + desensitizationtask.getClass().getSimpleName()).getBytes());
      if (byt_task != null) {
         Object obj = RedisTool.unserizlize(byt_task);
         desensitizationtask = (Desensitizationtask)obj;
      } else {
         desensitizationtask = this.dmpDesensitizationService.queryTaskById(taskid);
      }

      byte[] byt_source = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
      if (byt_source != null) {
         Object obj = RedisTool.unserizlize(byt_source);
         desensitizationsource = (Desensitizationsource)obj;
      } else {
         desensitizationsource = this.dmpDesensitizationService.querySourceInfo(taskid);
      }

      byte[] byt_target = jedis.get((tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName()).getBytes());
      if (byt_target != null) {
         Object obj = RedisTool.unserizlize(byt_target);
         desensitizationtarget = (Desensitizationtarget)obj;
      } else {
         desensitizationtarget = this.dmpDesensitizationService.queryTargetById(taskid);
      }

      map.put("desensitizationtask", desensitizationtask);
      map.put("desensitizationsource", desensitizationsource);
      map.put("desensitizationtarget", desensitizationtarget);
      if (desensitizationsource.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         map.put("tCoreDatasystem_source", tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      map.put("sourcetype", sourcetype);
      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else {
            targettype = "0";
         }
      }

      map.put("targettype", targettype);
      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         byte[] byt_file = jedis.get((tasknamereal + "_" + desensitizationfile.getClass().getSimpleName()).getBytes());
         if (byt_target != null) {
            Object obj = RedisTool.unserizlize(byt_file);
            desensitizationfile = (DesensitizationFile)obj;
         } else {
            desensitizationfile = this.dmpDesensitizationService.queryDesensitizationfileBytaskid(taskid);
         }

         map.put("desensitizationfile", desensitizationfile);
      }

      new ArrayList();
      List<Map<String, String>> var36 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      if (var36 != null) {
         var36 = (List)var36.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
      } else {
         var36 = new ArrayList();

         for(DesensitizationTable desensitizationTable : this.dmpDesensitizationService.queryTableList(taskid)) {
            Map<String, String> desensitizationTablemap = new HashMap();
            desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
            var36.add(desensitizationTablemap);
         }
      }

      map.put("tCoreMaskingTaskTableList", var36);
      return map;
   }

   @RequestMapping({"/inittasktable"})
   @ResponseBody
   public DataGridVO<DBTableVO> inittabledg(HttpServletRequest request, String tableNamePattern, Model model, String status) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();
      List<Map<String, String>> tableList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      if ("0".equals(status)) {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            list.add(dbTableVO);
         }
      } else {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            if (!status.equals("1") || !"0".equals(map.get("status")) && !"1".equals(map.get("status"))) {
               if (!status.equals("2") || !"2".equals(map.get("status")) && !"3".equals(map.get("status"))) {
                  if (!status.equals("3") || !"0".equals(map.get("status")) && !"2".equals(map.get("status"))) {
                     if (status.equals("4") && ("1".equals(map.get("status")) || "3".equals(map.get("status")))) {
                        dbTableVO.setTablename((String)map.get("tableName"));
                        dbTableVO.setStatus((String)map.get("status"));
                        list.add(dbTableVO);
                     }
                  } else {
                     dbTableVO.setTablename((String)map.get("tableName"));
                     dbTableVO.setStatus((String)map.get("status"));
                     list.add(dbTableVO);
                  }
               } else {
                  dbTableVO.setTablename((String)map.get("tableName"));
                  dbTableVO.setStatus((String)map.get("status"));
                  list.add(dbTableVO);
               }
            } else {
               dbTableVO.setTablename((String)map.get("tableName"));
               dbTableVO.setStatus((String)map.get("status"));
               list.add(dbTableVO);
            }
         }
      }

      if (!"".equals(tableNamePattern.trim())) {
         List<DBTableVO> tableSearchList = new ArrayList();

         for(DBTableVO dbTableVO : list) {
            if (dbTableVO.getTablename().indexOf(tableNamePattern) != -1) {
               tableSearchList.add(dbTableVO);
            }
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      } else {
         return new DataGridVO<DBTableVO>((long)list.size(), list);
      }
   }

   @RequestMapping({"/inputtable"})
   public String inputmulti(String flag, String title, String multivalue, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tableName = title;
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      byte[] byt = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
      if (byt != null) {
         Object obj = RedisTool.unserizlize(byt);
         desensitizationsource = (Desensitizationsource)obj;
      } else {
         String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
         desensitizationsource = this.dmpDesensitizationService.querySourceInfo(taskid);
      }

      String filedir = desensitizationsource.getSourcefiledir();
      String filename = "";
      String extension = ".txt";

      List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         if (tableName.equals(map.get("tableName"))) {
            if (((String)map.get("status")).equals("1")) {
               filedir = (String)map.get("filedir");
               filename = (String)map.get("filename");
               extension = (String)map.get("extension");
            }
            break;
         }
      }

      model.addAttribute("title", title);
      model.addAttribute("multivalue", multivalue);
      model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
      model.addAttribute("isfile", desensitizationsource.getDatasourceid() == null);
      model.addAttribute("dataschema", desensitizationsource.getDataschema());
      model.addAttribute("filedir", filedir);
      model.addAttribute("filename", filename);
      model.addAttribute("extension", extension);
      jedis.close();
      String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
      DesensitizationTable desensitizationTable = this.dmpDesensitizationService.queryTableByTableName(taskid, multivalue);
      if (desensitizationTable != null) {
         model.addAttribute("sqlFilter", desensitizationTable.getSqlFilter().replaceAll("'", "\\\\'"));
      } else {
         String sqlFilter = "";
         Map map = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
         if (map != null) {
            if (!"".equals((String)map.get(multivalue)) && (String)map.get(multivalue) != null) {
               sqlFilter = ((String)map.get(multivalue)).replaceAll("'", "\\\\'");
            } else {
               sqlFilter = (String)map.get(multivalue);
            }
         }

         model.addAttribute("sqlFilter", sqlFilter);
      }

      return "core/desensitizationtaskdmp/" + flag;
   }

   @ResponseBody
   @RequestMapping({"/checkWhereStatement"})
   public ResultVO checkWhereStatement(String dataSystemId, String schema, String whereStatements, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(dataSystemId);
      this.iskeberos(datasystem);
      Connection conn = JdbcTool.getConnection(datasystem);
      String[] tempArr = whereStatements.split(":");
      if (tempArr.length != 2) {
         return new ResultVO("过滤条件格式不正确！", false);
      } else {
         String sql = MessageFormat.format("select * from {0}.{1} where {2}", schema, tempArr[0], tempArr[1]);

         try {
            PreparedStatement statement = conn.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            resultSet.close();
            statement.close();
         } catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return new ResultVO(tempArr[0] + ": " + e.getMessage(), false);
         }

         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return new ResultVO((String)null, true);
      }
   }

   @RequestMapping({"/querycolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfo(String schemaName_tableName, HttpServletRequest request, HttpServletResponse response) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String schemaName = schemaName_tableName.substring(0, schemaName_tableName.lastIndexOf("-"));
      String tableName = schemaName_tableName.substring(schemaName_tableName.lastIndexOf("-") + 1, schemaName_tableName.length());
      List<ColumnInfoVO> list = new ArrayList();
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      byte[] bs = jedis.get(("dmpTransTask_Info_" + tasknamereal).getBytes());
      new ArrayList();
      if (bs != null) {
         List<TCoreMaskingTaskTableSchema> listNew = (List)RedisTool.unserizlize(bs);
         for(TCoreMaskingTaskTableSchema tCoreMaskingTaskTableSchema : listNew) {
            if (schemaName.equals(tCoreMaskingTaskTableSchema.getSchema())) {
               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableSchema.gettCoreMaskingTaskTableInfoList()) {
                  if (tableName.equals(tCoreMaskingTaskTableInfo.getTableName())) {
                     ColumnInfoVO columnInfoVO = new ColumnInfoVO();
                     columnInfoVO.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
                     columnInfoVO.setRemarks(tCoreMaskingTaskTableInfo.getRemark());
                     columnInfoVO.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
                     columnInfoVO.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
                     columnInfoVO.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
                     list.add(columnInfoVO);
                  }
               }
            }
         }
      }

      return list;
   }

   @RequestMapping({"/querycolumninfodiff"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfodiff(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      byte[] byt = jedis.get((tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName()).getBytes());
      if (byt == null) {
         jedis.close();
         return null;
      } else {
         Object obj = RedisTool.unserizlize(byt);
         desensitizationtarget = (Desensitizationtarget)obj;
         String var33 = id.replace(tablename, "");
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(var33);
         if (tCoreDatasystemSource == null) {
            jedis.close();
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            Map<String, String> targetFieldNameMap = new HashMap();

            for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
               String targetName = "";
               String fieldname = desensitizationDataTargetfield.getFieldname();

               for(Map<String, String> map : map_t) {
                  if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
                     targetName = ((String)map.get("sourcefieldname")).toLowerCase();
                     break;
                  }
               }

               targetFieldNameMap.put(fieldname, targetName);
            }

            Connection conn = this.maskingTaskService.getConnectionByDataSystemId(var33);
            List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tablename);
            List<ColumnInfoVO> list1 = new ArrayList();
            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               for(ColumnInfoVO civ : list) {
                  if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                     civ.setDecimaldigits("");
                  }

                  list1.add(civ);
               }

               if (jedis.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
                  byte[] taskByt = jedis.get((tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename).getBytes());
                  if (taskByt != null) {
                     new ArrayList();
                     Object taskObj = RedisTool.unserizlize(taskByt);
                     List<TCoreMaskingTaskTableInfo> var43 = (List)taskObj;

                     for(ColumnInfoVO civ : list1) {
                        for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var43) {
                           if (civ.getColumnname().equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                              civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                              break;
                           }
                        }
                     }
                  }
               } else {
                  for(ColumnInfoVO civ : list1) {
                     for(Map<String, String> map : map_s) {
                        if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                           civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                           break;
                        }
                     }
                  }
               }
            } else if (jedis.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
               byte[] taskByt = jedis.get((tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename).getBytes());
               if (taskByt != null) {
                  new ArrayList();
                  Object taskObj = RedisTool.unserizlize(taskByt);
                  List<TCoreMaskingTaskTableInfo> var45 = (List)taskObj;

                  for(ColumnInfoVO civ : list) {
                     for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var45) {
                        if (this.delparentheses(civ.getColumnname()).equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                           civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                           break;
                        }
                     }
                  }
               }
            } else {
               for(ColumnInfoVO civ : list) {
                  for(Map<String, String> map : map_s) {
                     if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                        civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                        break;
                     }
                  }
               }
            }

            try {
               if (conn != null) {
                  conn.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               jedis.close();
               return list1;
            } else {
               jedis.close();
               return list;
            }
         }
      }
   }

   @RequestMapping({"/querycolumntypediff"})
   @ResponseBody
   public List<ComboboxVO> querycolumntype(HttpServletRequest request, HttpServletResponse response, Model model, String sourceColumnType) {
      List<ComboboxVO> list = new ArrayList();
      sourceColumnType = this.delparentheses(sourceColumnType);
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      byte[] byt_s = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
      if (byt_s == null) {
         return null;
      } else {
         Object obj = RedisTool.unserizlize(byt_s);
         desensitizationsource = (Desensitizationsource)obj;
         byte[] byt_t = jedis.get((tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName()).getBytes());
         if (byt_t == null) {
            return null;
         } else {
            Object objNew = RedisTool.unserizlize(byt_t);
            desensitizationtarget = (Desensitizationtarget)objNew;
            TCoreDatasystem var28 = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(var28.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            String fieldName = "";

            for(Map<String, String> map : map_s) {
               if (sourceColumnType.toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                  fieldName = (String)map.get("targetfieldname");
               }
            }

            List<String> targetFieldNameList = new ArrayList();

            for(Map<String, String> map : map_t) {
               if (fieldName.equals(map.get("targetfieldname"))) {
                  targetFieldNameList.add(((String)map.get("sourcefieldname")).toLowerCase());
               }
            }

            for(String string : targetFieldNameList) {
               ComboboxVO c = new ComboboxVO(string);
               list.add(c);
            }

            return list;
         }
      }
   }

   @RequestMapping({"/querycolumnfileinfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumnfileinfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/queryfilecolumnbyid"})
   @ResponseBody
   public List<TCoreFileStructurecolumnVO> queryfilecolumnbyid(String structureid) {
      List<TCoreFileStructurecolumn> list = this.fileSystemService.queryFileStructureColumn(structureid);
      List<TCoreFileStructurecolumnVO> volist = null;

      try {
         volist = ObjectTool.listConvert(list, TCoreFileStructurecolumnVO.class);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return volist;
   }

   @RequestMapping({"/savetableinfo"})
   @ResponseBody
   public boolean savetableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap, String filterConditions) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String schema_tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String schemaName = schema_tableName.substring(0, schema_tableName.lastIndexOf("-"));
      String tableName = schema_tableName.substring(schema_tableName.lastIndexOf("-") + 1, schema_tableName.length());
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      byte[] byt = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
      if (!"".equals(filterConditions) && filterConditions != null) {
         if (request.getSession().getAttribute(tasknamereal + "_" + "filterConditions") == null) {
            Map<String, String> map = new HashMap();
            map.put(schema_tableName, filterConditions);
            request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", map);
         } else {
            ((Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions")).put(schema_tableName, filterConditions);
         }
      }

      if (byt == null) {
         jedis.close();
         return false;
      } else {
         Object obj = RedisTool.unserizlize(byt);
         desensitizationsource = (Desensitizationsource)obj;
         List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfo(schemaName, tableName);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][primarykey]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][typename]"));
            tCoreMaskingTaskTableInfo.setTargetType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][targettypename]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnsize]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][decimaldigits]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         jedis.set((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]")).getBytes(), RedisTool.serialize(tCoreMaskingTaskTableInfoList));

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (schema_tableName.equals(map.get("tableName"))) {
               if (((String)map.get("status")).equals("0")) {
                  map.put("status", "2");
               } else if (((String)map.get("status")).equals("1")) {
                  map.put("status", "3");
               }
            }
         }

         jedis.close();
         return true;
      }
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   public List<ColumnInfoVO> queryColumnInfo(String schema, String tableName) {
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      List<ColumnInfoVO> list = new ArrayList();
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      byte[] bs = jedis.get(("dmpTransTask_Info_" + tasknamereal).getBytes());
      new ArrayList();
      if (bs != null) {
         List<TCoreMaskingTaskTableSchema> listNew = (List)RedisTool.unserizlize(bs);
         for(TCoreMaskingTaskTableSchema tCoreMaskingTaskTableSchema : listNew) {
            if (schema.equals(tCoreMaskingTaskTableSchema.getSchema())) {
               for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableSchema.gettCoreMaskingTaskTableInfoList()) {
                  if (tableName.equals(tCoreMaskingTaskTableInfo.getTableName())) {
                     ColumnInfoVO columnInfoVO = new ColumnInfoVO();
                     columnInfoVO.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
                     columnInfoVO.setRemarks(tCoreMaskingTaskTableInfo.getRemark());
                     columnInfoVO.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
                     columnInfoVO.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
                     columnInfoVO.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
                     list.add(columnInfoVO);
                  }
               }
            }
         }
      }

      return list;
   }

   @RequestMapping({"/savefiletableinfo"})
   @ResponseBody
   public boolean savefiletableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String structureid = (String)tableInfoMap.get("tableInfoMap[structureid]");
      String filedir = (String)tableInfoMap.get("tableInfoMap[filedir]");
      String filename = (String)tableInfoMap.get("tableInfoMap[filename]");
      String extension = (String)tableInfoMap.get("tableInfoMap[extension]");
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      byte[] byt = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
      if (byt == null) {
         jedis.close();
         return false;
      } else {
         Object obj = RedisTool.unserizlize(byt);
         desensitizationsource = (Desensitizationsource)obj;
         List<TCoreFileStructurecolumn> queryColumnInfo = this.fileSystemService.queryFileStructureColumn(structureid);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][keytype]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columntype]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnaccuracy]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columndecimal]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         jedis.set((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]")).getBytes(), RedisTool.serialize(tCoreMaskingTaskTableInfoList));

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("filedir", filedir);
               map.put("filename", filename);
               map.put("extension", extension);
               map.put("status", "1");
            }
         }

         jedis.close();
         return true;
      }
   }

   @RequestMapping({"/savechoosetable"})
   @ResponseBody
   public boolean saveChooseTable(String tableName, String chooseType, HttpServletRequest request) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();

      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         new ArrayList();
         List<Map<String, String>> list = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if ("onCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes())) {
                  map.put("status", "3");
               } else if (tableName.equals(map.get("tableName")) && !jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes())) {
                  map.put("status", "1");
               }
            }
         } else if ("onUnCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes())) {
                  map.put("status", "2");
               } else if (tableName.equals(map.get("tableName")) && !jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes())) {
                  map.put("status", "0");
               }
            }
         } else if ("onCheckAll".equals(chooseType)) {
            if (!"".equals(tableName) && tableName != null) {
               String[] tableNameArr = tableName.split(",");
               if (tableNameArr.length > 0) {
                  for(Map<String, String> map : list) {
                     if (jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes()) && Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                        map.put("status", "3");
                     } else if (!jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes()) && Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                        map.put("status", "1");
                     }
                  }
               }
            }
         } else if ("onUnCheckAll".equals(chooseType) && !"".equals(tableName) && tableName != null) {
            String[] tableNameArr = tableName.split(",");
            if (tableNameArr.length > 0) {
               for(Map<String, String> map : list) {
                  if (jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes()) && !Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                     map.put("status", "2");
                  } else if (!jedis.exists((tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")).getBytes()) && !Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                     map.put("status", "0");
                  }
               }
            }
         }

         request.getSession().setAttribute("tableList_" + tasknamereal, list);
         jedis.close();
         return true;
      } catch (Exception e) {
         jedis.close();
         e.printStackTrace();
         return false;
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/getTableColumnSensitiveRule"},
      method = {RequestMethod.GET}
   )
   public void getSensitiveByIdBySchema(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      PrintWriter writer = null;
      String schema = (String)parameter.get("schema");
      String table = (String)parameter.get("table");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      if (jedis.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table)) {
         byte[] taskByt = jedis.get((tasknamereal + "_TCoreMaskingTaskTableInfo_" + table).getBytes());
         if (taskByt != null) {
            new ArrayList();
            Object taskObj = RedisTool.unserizlize(taskByt);

            List<TCoreMaskingTaskTableInfo> listNew = (List)taskObj;
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : listNew) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               tcoreDiscoverySensitivecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexRuleName());
               tcoreDiscoverySensitivecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      } else {
         byte[] byt = jedis.get((table + "+" + schema).getBytes());
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            new ArrayList();
            List<TCoreFieldSensitiveMemory> var21 = (List)obj;

            for(int i = 0; i < var21.size(); ++i) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(((TCoreFieldSensitiveMemory)var21.get(i)).getColumnname());
               tcoreDiscoverySensitivecolumn.setRegextype(((TCoreFieldSensitiveMemory)var21.get(i)).getRegextype());
               tcoreDiscoverySensitivecolumn.setRuleid(((TCoreFieldSensitiveMemory)var21.get(i)).getRuleid());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      }

      jedis.close();

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/resetTableInfo"})
   public boolean resetTableInfo(HttpServletRequest request, String tableName) {
      try {
         RedisClient redisClient = new RedisClient();
         Jedis jedis = redisClient.getJedis();
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         jedis.del(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tableName);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               if (((String)map.get("status")).equals("2")) {
                  map.put("status", "0");
               } else if (((String)map.get("status")).equals("3")) {
                  map.put("status", "1");
               }
            }
         }

         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @RequestMapping({"/editDesensitizationTask"})
   public String editDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      model.addAttribute("taskid", taskid);
      Desensitizationtask desensitizationtask = this.dmpDesensitizationService.queryTaskById(taskid);
      String tasktype = desensitizationtask.getTasktype();
      String sourcetype = tasktype.split("to")[0];
      String path = "";
      request.getSession().setAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      request.getSession().setAttribute(desensitizationtask.getTasknamereal() + "_taskid", taskid);
      this.dmpDesensitizationService.querySourceInfo(taskid);
      this.dmpDesensitizationService.queryTargetInfo(taskid);
      List<Map<String, String>> tableList = new ArrayList();
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      byte[] bs = jedis.get(("dmpTransTask_Info_" + desensitizationtask.getTasknamereal()).getBytes());
      new ArrayList();
      Map<String, String> mapTemp = new HashMap();
      if (bs != null) {
         List<TCoreMaskingTaskTableSchema> tCoreMaskingTaskTableSchemaList = (List)RedisTool.unserizlize(bs);
         String schema = null;

         for(TCoreMaskingTaskTableSchema tCoreMaskingTaskTableSchema : tCoreMaskingTaskTableSchemaList) {
            schema = tCoreMaskingTaskTableSchema.getSchema();

            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableSchema.gettCoreMaskingTaskTableInfoList()) {
               mapTemp.put(schema + "-" + tCoreMaskingTaskTableInfo.getTableName(), "0");
               System.out.println("tableName=" + tCoreMaskingTaskTableInfo.getTableName());
            }
         }
      }

      for(DesensitizationTable desensitizationTable : this.dmpDesensitizationService.queryTableList(taskid)) {
         mapTemp.put(desensitizationTable.getTablename(), desensitizationTable.getStatus());
      }

      List<DBTableVO> list = new ArrayList();

      for(String key : mapTemp.keySet()) {
         DBTableVO dbTableVO = new DBTableVO();
         dbTableVO.setTablename(key);
         dbTableVO.setStatus((String)mapTemp.get(key));
         list.add(dbTableVO);
      }

      Collections.sort(list);

      for(DBTableVO dbTableVO : list) {
         Map<String, String> map = new HashMap();
         map.put("tableName", dbTableVO.getTablename());
         map.put("status", dbTableVO.getStatus());
         tableList.add(map);
      }

      model.addAttribute("mappingEditFlag", "dbsystem");
      request.getSession().setAttribute("tableList_" + desensitizationtask.getTasknamereal(), tableList);
      return "core/desensitizationtaskdmp/taskedit/desensitizationtask_edit";
   }

   @RequestMapping({"/showDesensitizationTask"})
   public String showDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      model.addAttribute("taskid", taskid);
      return "core/desensitizationtaskdmp/taskedit/desensitizationtask_show";
   }

   @RequestMapping({"/querymultitable"})
   @ResponseBody
   public List<ColumnInfoVO> querymultitable(String taskid, String schema_table, HttpServletRequest request) {
      String schemaName = schema_table.substring(0, schema_table.lastIndexOf("-"));
      String tableName = schema_table.substring(schema_table.lastIndexOf("-") + 1, schema_table.length());
      if (taskid == null) {
         RedisClient redisClient = new RedisClient();
         Jedis jedis = redisClient.getJedis();
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         List<ColumnInfoVO> queryColumnInfo = new ArrayList();
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         byte[] byt = jedis.get((tasknamereal + "_" + desensitizationsource.getClass().getSimpleName()).getBytes());
         if (byt != null) {
            Object obj = RedisTool.unserizlize(byt);
            desensitizationsource = (Desensitizationsource)obj;
         } else {
            desensitizationsource = this.dmpDesensitizationService.querySourceInfo(taskid);
         }

         byte[] byt_table_columinfo = jedis.get((tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + schema_table).getBytes());
         HashMap<String, String> map = new HashMap();
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();
         if (byt_table_columinfo != null) {
            Object obj_tCoreMaskingTaskTableInfo = RedisTool.unserizlize(byt_table_columinfo);
            tCoreMaskingTaskTableInfoList = (List)obj_tCoreMaskingTaskTableInfo;

            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
            }
         } else {
            queryColumnInfo = this.queryColumnInfo(schemaName, tableName);
            if (jedis.exists((tableName + "+" + desensitizationsource.getDataschema()).getBytes())) {
               byte[] mebyt = jedis.get((tableName + "+" + schemaName).getBytes());
               if (mebyt != null) {
                  Object obj_rule = RedisTool.unserizlize(mebyt);
                  new ArrayList();

                  List<TCoreFieldSensitiveMemory> listNew = (List)obj_rule;
                  for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : listNew) {
                     map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory.getRuie());
                  }
               }
            }
         }

         if (tCoreMaskingTaskTableInfoList != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
               columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
               columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
               queryColumnInfo.add(columnInfo);
            }
         }

         for(ColumnInfoVO columnInfo : queryColumnInfo) {
            columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");
         }

         jedis.close();
         return queryColumnInfo;
      } else {
         List<ColumnInfoVO> queryColumnInfo = new ArrayList();

         for(DesensitizationTablecolumn desensitizationTablecolumn : this.dmpDesensitizationService.queryColumInfo(taskid, schema_table)) {
            ColumnInfoVO columnInfo = new ColumnInfoVO();
            columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
            columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
            columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
            columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
            columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRulename()) ? "无" : desensitizationTablecolumn.getRulename());
            queryColumnInfo.add(columnInfo);
         }

         return queryColumnInfo;
      }
   }

   @RequestMapping(
      value = {"/removetask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public void removetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.dmpDesensitizationService.removeTask(taskid);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("数据脱敏");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setLogmessage("删除数据脱敏任务");
      this.operationService.add(record);
   }

   @RequestMapping({"/executeDesensitizationTask"})
   public String executeDesensitizationTask(HttpServletRequest request, Model model, String taskid) {
      try {
         Desensitizationsource desensitizationsource = this.dmpDesensitizationService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.dmpDesensitizationService.queryTargetById(taskid);
         Desensitizationtask desensitizationtask = this.dmpDesensitizationService.queryTaskById(taskid);
         TCoreDatasystem tCoreDatasystemSource = new TCoreDatasystem();
         TCoreDatasystem tCoreDatasystemTarget = new TCoreDatasystem();
         tCoreDatasystemSource.setDbtype("FILE");
         if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
            tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         } else {
            tCoreDatasystemTarget.setDbtype("FILE");
         }

         InfoProperty infoProperty = this.dmpDesensitizationService.getInfoProperty();
         long groupId = (new Date()).getTime();
         ExecuteParam executeParam = new ExecuteParam();
         executeParam.setSourceDataSystem(tCoreDatasystemSource);
         executeParam.setTargetDataSystem(tCoreDatasystemTarget);
         executeParam.setInfoProperty(infoProperty);
         executeParam.setDataSourceId(desensitizationsource.getDatasourceid());
         executeParam.setDataTargetId(desensitizationtarget.getDatasourceid());
         executeParam.setFolderName(desensitizationtask.getFoldername());
         executeParam.setSourceSchemaName(desensitizationsource.getDataschema());
         executeParam.setTargetSchemaName(desensitizationtarget.getDataschema());
         executeParam.setIsPrimary(desensitizationtarget.getIsprimary());
         executeParam.setIsIndex(desensitizationtarget.getIsindex());
         executeParam.setTaskid(taskid);
         executeParam.setSourceFileDir(desensitizationsource.getSourcefiledir());
         executeParam.setTaskNameReal(desensitizationtask.getTasknamereal());
         executeParam.setSourcetype(desensitizationsource.getExecution_type());
         executeParam.setTargettype(desensitizationtarget.getExecution_type());
         executeParam.setLoadscripttype(desensitizationtarget.getLoadscripttype());
         String taskType = JdbcTool.returnTaskType(desensitizationtask.getTasktype());
         List<DesensitizationTable> tableList = this.dmpDesensitizationService.queryTableList(taskid);
         Map<String, String> tableMap = new HashMap();
         StringBuilder batchInserSql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationMonitor());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "desensitization_monitor");
         batchInserSql.append(sqlBase);

         for(DesensitizationTable desensitizationTable : tableList) {
            String id = UUID.randomUUID().toString();
            tableMap.put(desensitizationTable.getTablename(), id);
            DesensitizationMonitor desensitizationMonitor = new DesensitizationMonitor();
            desensitizationMonitor.setId(id);
            desensitizationMonitor.setSourcename(desensitizationTable.getTablename());
            desensitizationMonitor.setTargetname(desensitizationTable.getTablename());
            desensitizationMonitor.setRunstatus(0);
            desensitizationMonitor.setGroupid(new BigInteger(String.valueOf(groupId)));
            desensitizationMonitor.setTaskid(taskid);
            desensitizationMonitor.setTasktype(taskType);
            batchInserSql.append(JdbcTool.sql_insert_h(desensitizationMonitor, list_table));
         }

         executeParam.setTableMap(tableMap);
         this.dmpDesensitizationService.saveDesensitizationMonitor(batchInserSql.deleteCharAt(batchInserSql.length() - 1));
         this.dmpDesensitizationService.executeTaskNormal(executeParam);
         model.addAttribute("taskid", taskid);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return "core/desensitizationmonitordmp/monitorrun";
   }

   @RequestMapping({"/detail"})
   public String detail(String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model) throws SQLException {
      model.addAttribute("taskid", taskid);
      return "core/desensitizationtaskdmp/desensitizationtask_details";
   }

   @RequestMapping({"/isrun"})
   @ResponseBody
   public boolean isrun(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      long num_exeing = this.dmpDesensitizationService.getExeTaskNum();
      long num_table = this.dmpDesensitizationService.getTableNum(taskid);
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      long num_thread = new Long(props.getProperty("threadPool.queueCapacity"));
      return num_exeing + num_table < num_thread;
   }

   @RequestMapping({"/checksystem"})
   @ResponseBody
   public Map<String, Object> checksystem(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      Map<String, Object> map = new HashMap();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      Float sys_Alert_Threshold = new Float(props.getProperty("Sys_Alert_Threshold"));
      sys_Alert_Threshold = sys_Alert_Threshold * 100.0F;
      map.put("flag", false);

      try {
         if (!((double)sys_Alert_Threshold <= SysUtils.cpuUsage()) && !((double)sys_Alert_Threshold <= SysUtils.memoryUsage()) && !((double)sys_Alert_Threshold <= SysUtils.getDiskUsage())) {
            map.put("flag", false);
         } else {
            System.out.println("CPU利用率：" + SysUtils.cpuUsage());
            System.out.println("内存占用率：" + SysUtils.memoryUsage());
            System.out.println("磁盘空间占用率：" + SysUtils.getDiskUsage());
            map.put("disk", SysUtils.getDiskUsage());
            map.put("cpu", SysUtils.cpuUsage());
            map.put("memory", SysUtils.memoryUsage());
            map.put("flag", true);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return map;
   }

   public String source_type(Map<String, String> map) {
      String sourceType = "";
      RedisClient redisClient = new RedisClient();
      Jedis jedis = redisClient.getJedis();
      String tasknamereal = (String)map.get("tasknamereal");
      byte[] sourceByte = jedis.get((tasknamereal + "_" + "Desensitizationsource").getBytes());
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      if (sourceByte != null) {
         desensitizationsource = (Desensitizationsource)RedisTool.unserizlize(sourceByte);
      }

      String datasourceid = desensitizationsource.getDatasourceid();
      if (datasourceid != null && !"".equals(datasourceid)) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
         String dbtype = tCoreDatasystem.getDbtype();
         if (!dbtype.equals("FTP") && !dbtype.equals("SFTP")) {
            sourceType = "db";
         } else {
            sourceType = "file";
         }
      } else {
         sourceType = "file";
      }

      return sourceType;
   }

   @RequestMapping({"/structure/querystructurebygroup"})
   @ResponseBody
   public DataGridVO<DBTableVO> querystructurebygroup(String groupname, String tableNamePattern) {
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();

      List<Map<String, String>> listNew = (List)this.request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         DBTableVO dbTableVO = new DBTableVO();
         if ("0".equals(map.get("status")) || "1".equals(map.get("status"))) {
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            dbTableVO.setDatasystemid((String)map.get("structureid"));
            list.add(dbTableVO);
         }
      }

      if (!"".equals(tableNamePattern.trim())) {
         List<DBTableVO> tableSearchList = new ArrayList();

         for(DBTableVO dbTableVO : list) {
            if (dbTableVO.getTablename().indexOf(tableNamePattern) != -1) {
               tableSearchList.add(dbTableVO);
            }
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      } else {
         return new DataGridVO<DBTableVO>((long)list.size(), list);
      }
   }

   @RequestMapping({"/getFileContent"})
   @ResponseBody
   public Map<String, Object> getFileContent(@RequestParam("file") MultipartFile file, String charset) {
      System.out.println("开始");
      String path = "D:\\";
      String uuid = UUID.randomUUID().toString();
      File dbffile = new File(path + uuid + ".dbf");

      try {
         dbffile.createNewFile();
         file.transferTo(dbffile);
      } catch (Exception e) {
         e.printStackTrace();
      }

      Map<String, String> map = transdbf.selectdbf(charset, dbffile, ",");
      Map<String, Object> map_list = new HashMap();
      String content = (String)map.get("content");
      String[] a = content.split("\\\n");
      List<String> list = new ArrayList();

      for(String string : a) {
         list.add(string);
      }

      map_list.put("list", list);
      map_list.put("title", map.get("fieldtitle"));
      return map_list;
   }

   @RequestMapping({"/source_isnull"})
   @ResponseBody
   public boolean source_isnull(String taskid, String tableNamePattern) {
      boolean isnull = true;
      Desensitizationsource desensitizationsource = this.dmpDesensitizationService.querySourceInfo(taskid);
      if (desensitizationsource.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         if (tCoreDatasystemSource == null) {
            isnull = false;
         }
      }

      return isnull;
   }

   public String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }
}
