package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineProperty;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineType;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.engine.EnginePropertyVO;
import com.chenyang.nse.bussiness.service.console.EngineManageService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.EngineService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/engine"})
public class EngineController {
   @Autowired
   private EngineService engineService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private EngineManageService engineManageService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/engine/engine";
   }

   @RequestMapping({"/save"})
   public void save(@RequestBody TCoreEngine engine, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.engineService.save(engine);
   }

   @RequestMapping({"/queryAllEngines"})
   @ResponseBody
   public List<TCoreEngine> queryAllEngines(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.engineService.queryAllEngine();
   }

   @RequestMapping({"/queryenginetype"})
   @ResponseBody
   public List<TConsoleEngineType> queryenginetype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsoleEngineType> enginetype = this.engineManageService.queryAllEngineType();
      return enginetype;
   }

   @RequestMapping({"/querypropertyvalue"})
   @ResponseBody
   public List<EnginePropertyVO> querypropertyvalue(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<EnginePropertyVO> propertyValue = this.engineService.queryPropertyValue(engineid);

      for(int i = propertyValue.size() - 1; i > 0; --i) {
         if ("datasystemid".equals(((EnginePropertyVO)propertyValue.get(i)).getPropertyname())) {
            propertyValue.remove(i);
         }
      }

      return propertyValue;
   }

   @RequestMapping({"/querydatasystem"})
   @ResponseBody
   public List<TCoreDatasystem> querydatasystem(HttpServletRequest request, HttpServletResponse response, Model model) {
      String flag = "1";
      List<TCoreDatasystem> datasystem = this.dataSystemService.query(flag);
      List<TCoreDatasystem> datasystemsbyone = (List)datasystem.stream().filter((s) -> "402882e9608bf3c001608c09a7410042".equals(s.getId())).collect(Collectors.toList());
      return datasystemsbyone;
   }

   @RequestMapping({"/querydatasystembyid"})
   @ResponseBody
   public TCoreDatasystem querydatasystembyid(String id, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(id);
      return datasystem;
   }

   @RequestMapping({"/queryengineproperty"})
   @ResponseBody
   public List<TConsoleEngineProperty> queryengineproperty(String enginetypeid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TConsoleEngineProperty> list = this.engineManageService.queryEngineProperty(enginetypeid);
      return list;
   }

   @RequestMapping({"/remove"})
   public void remove(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.engineService.remove(engineid);
   }

   @RequestMapping({"/testConnect"})
   @ResponseBody
   public ResultVO testConnect(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      String text = this.engineService.testConnect(engineid);
      return "SUCCESS".equals(text) ? new ResultVO(text, true) : new ResultVO(text, false);
   }

   @RequestMapping({"/start"})
   public void start(String serviceName, HttpServletRequest request, HttpServletResponse response, Model model) {
   }

   @RequestMapping({"/stop"})
   public void stop(String serviceName, HttpServletRequest request, HttpServletResponse response, Model model) {
   }

   @RequestMapping({"/restart"})
   public void restart(String serviceName, HttpServletRequest request, HttpServletResponse response, Model model) {
   }

   @RequestMapping({"/isStarted"})
   @ResponseBody
   public boolean isStarted(String serviceName, HttpServletRequest request, HttpServletResponse response, Model model) {
      return false;
   }

   @RequestMapping({"/dir"})
   @ResponseBody
   public List<TreeVO> dir(String path, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TreeVO> vo = null;
      if (null != path && !"".equals(path)) {
         vo = new ArrayList();
         List<String> dir = FileTool.getPathDir(path);
         String prefix = null;

         for(String item : dir) {
            prefix = path.endsWith(File.separator) ? path : path + File.separator;
            vo.add(new TreeVO(prefix + item, item, "closed", "false", (List)null));
         }

         for(String item : FileTool.getPathFile(path)) {
            prefix = path.endsWith(File.separator) ? path : path + File.separator;
            vo.add(new TreeVO(prefix + item, item, "open", "false", (List)null));
         }

         return vo;
      } else {
         vo = new ArrayList();
         List<String> root = FileTool.getRootDir();
         File f = null;

         for(String item : root) {
            f = new File(item);
            if (f.isFile()) {
               vo.add(new TreeVO(item, item, "open", "false", (List)null));
            } else if (f.isDirectory()) {
               vo.add(new TreeVO(item, item, "closed", "false", (List)null));
            }
         }

         return vo;
      }
   }
}
