package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.orm.table.core.findCharts.EchartsFour;
import com.chenyang.nse.bussiness.entity.orm.table.core.findCharts.EchartsOne;
import com.chenyang.nse.bussiness.entity.orm.table.core.findCharts.Echartsfive;
import com.chenyang.nse.bussiness.entity.orm.table.core.findCharts.Echartsseven;
import com.chenyang.nse.bussiness.entity.orm.table.core.findCharts.Echartssix;
import com.chenyang.nse.bussiness.entity.orm.table.core.findCharts.Echartstwo;
import com.chenyang.nse.bussiness.service.core.charts.FindEchartsService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/findcharts"})
public class MultiFindEchartsController {
   @Autowired
   private FindEchartsService findEchartsService;

   @RequestMapping
   public String view(String index, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/chart/findcharts";
   }

   @RequestMapping({"/taskid"})
   @ResponseBody
   public List<EchartsOne> findAllTaskid() {
      List<EchartsOne> list1 = this.findEchartsService.findAllTaskid();
      return list1;
   }

   @RequestMapping({"/one"})
   @ResponseBody
   public EchartsOne findNameByTaskidOne(String taskid) {
      EchartsOne echartsOne = new EchartsOne();
      List<Map<String, Object>> list1 = this.findEchartsService.findNameByTaskidOne(taskid);
      if (list1 != null && !list1.isEmpty()) {
         String nonsensitiveNumber = (String)((Map)list1.get(0)).get("nonsensitiveNumber");
         echartsOne.setNonsensitiveNumber(nonsensitiveNumber);
         String sensitiveNumber = (String)((Map)list1.get(0)).get("sensitiveNumber");
         echartsOne.setSensitiveNumber(sensitiveNumber);
         String taskName = (String)((Map)list1.get(0)).get("taskName");
         echartsOne.setTaskName(taskName);
      }

      return echartsOne;
   }

   @RequestMapping({"/two"})
   @ResponseBody
   public Echartstwo findNameByTaskidTwo(String taskid) {
      Echartstwo echartstwo = new Echartstwo();
      List<Map<String, Object>> list1 = this.findEchartsService.findNameByTaskidTwo(taskid);
      if (list1 != null && !list1.isEmpty()) {
         String nonsensitivepieNumber = (String)((Map)list1.get(0)).get("nonsensitivepieNumber");
         echartstwo.setNonsensitivepieNumber(nonsensitivepieNumber);
         String sensitivepieNumber = (String)((Map)list1.get(0)).get("sensitivepieNumber");
         echartstwo.setSensitivepieNumber(sensitivepieNumber);
         String taskpieName = (String)((Map)list1.get(0)).get("taskpieName");
         echartstwo.setTaskpieName(taskpieName);
      }

      return echartstwo;
   }

   @RequestMapping({"/three"})
   @ResponseBody
   public List<Map<String, Object>> findNameByTaskidThree(String taskid) {
      List<Map<String, Object>> list = this.findEchartsService.findNameByVersionidThree(taskid);
      return list;
   }

   @RequestMapping({"/four"})
   @ResponseBody
   public EchartsFour findNameByTaskidFour(String taskid) {
      EchartsFour echartsFour = new EchartsFour();
      List<Map<String, Object>> list1 = this.findEchartsService.findNameByTaskidFour(taskid);
      if (list1 != null && !list1.isEmpty()) {
         String datafiledNumber = (String)((Map)list1.get(0)).get("datafiledNumber");
         echartsFour.setDatafiledNumber(datafiledNumber);
         String taskName = (String)((Map)list1.get(0)).get("taskName");
         echartsFour.setTaskName(taskName);
      }

      return echartsFour;
   }

   @RequestMapping({"/five"})
   @ResponseBody
   public List<Map<String, Object>> findNameByTaskidFive(String taskid) {
      List<Map<String, Object>> list1 = this.findEchartsService.findNameByVersionidFive(taskid);
      return list1;
   }

   @RequestMapping({"/six"})
   @ResponseBody
   public Echartssix findNameByTaskidSix(String taskid) {
      Echartssix echartsSix = new Echartssix();
      List<Map<String, Object>> list1 = this.findEchartsService.findNameByTaskidSix(taskid);
      if (list1 != null && !list1.isEmpty()) {
         String nonsensitivetableNumber = (String)((Map)list1.get(0)).get("nonsensitivetableNumber");
         echartsSix.setNonsensitivetableNumber(nonsensitivetableNumber);
         String sensitivetableNumber = (String)((Map)list1.get(0)).get("sensitivetableNumber");
         echartsSix.setSensitivetableNumber(sensitivetableNumber);
         String taskName = (String)((Map)list1.get(0)).get("taskName");
         echartsSix.setTaskName(taskName);
      }

      return echartsSix;
   }

   @RequestMapping({"/seven"})
   @ResponseBody
   public Echartsseven findNameByTaskidSeven(String taskid) {
      Echartsseven echartsseven = new Echartsseven();
      List<Map<String, Object>> list1 = this.findEchartsService.findNameByTaskidSeven(taskid);
      if (list1 != null && !list1.isEmpty()) {
         String nonsensitivetableNumber = (String)((Map)list1.get(0)).get("nonsensitivetableNumber");
         echartsseven.setNonsensitivetableNumber(nonsensitivetableNumber);
         String sensitivetableNumber = (String)((Map)list1.get(0)).get("sensitivetableNumber");
         echartsseven.setSensitivetableNumber(sensitivetableNumber);
         String taskName = (String)((Map)list1.get(0)).get("taskName");
         echartsseven.setTaskName(taskName);
      }

      return echartsseven;
   }

   @RequestMapping({"/multipleone"})
   @ResponseBody
   public ArrayList<EchartsOne> findByTaskidmultipleOne(@RequestBody String[] taskidarr) throws IOException {
      ArrayList<EchartsOne> list = new ArrayList();
      if (taskidarr != null || taskidarr.length != 0) {
         for(String string : taskidarr) {
            EchartsOne echartsOne = this.findNameByTaskidOne(string);
            list.add(echartsOne);
         }
      }

      return list;
   }

   @RequestMapping({"/multipletwo"})
   @ResponseBody
   public ArrayList<Echartstwo> findByTaskidmultipleTwo(@RequestBody String[] taskidarr) throws IOException {
      ArrayList<Echartstwo> list = new ArrayList();
      if (taskidarr != null || taskidarr.length != 0) {
         for(String string : taskidarr) {
            Echartstwo echartsTwo = this.findNameByTaskidTwo(string);
            list.add(echartsTwo);
         }
      }

      return list;
   }

   @RequestMapping({"/multiplethree"})
   @ResponseBody
   public List<Map<String, Object>> findNameBymultipleThree(@RequestBody String[] taskidarr) throws IOException {
      List<Map<String, Object>> list = new ArrayList();
      new ArrayList();
      if (taskidarr != null || taskidarr.length != 0) {
         for(String string : taskidarr) {
            Map<String, Object> map = new HashMap();
            List<Map<String, Object>> list1 = this.findNameByTaskidThree(string);
            Echartsfive echartsfive = this.findNameByTask(string);
            map.put("versionList", list1);
            map.put("task", echartsfive.getTaskName());
            list.add(map);
         }
      }

      return list;
   }

   @RequestMapping({"/multiplfour"})
   @ResponseBody
   public ArrayList<EchartsFour> findByTaskidmultipleFour(@RequestBody String[] taskidarr) throws IOException {
      ArrayList<EchartsFour> list = new ArrayList();
      if (taskidarr != null || taskidarr.length != 0) {
         for(String string : taskidarr) {
            EchartsFour echartsFour = this.findNameByTaskidFour(string);
            list.add(echartsFour);
         }
      }

      return list;
   }

   @RequestMapping({"/multiplefive"})
   @ResponseBody
   public List<Map<String, Object>> findNameBymultipleFive(@RequestBody String[] taskidarr) throws IOException {
      List<Map<String, Object>> list = new ArrayList();
      if (taskidarr != null && taskidarr.length != 0) {
         for(String string : taskidarr) {
            Map<String, Object> map = new HashMap();
            List<Map<String, Object>> list1 = this.findNameByTaskidFive(string);
            Echartsfive echartsfive = this.findNameByTask(string);
            map.put("versionList", list1);
            map.put("task", echartsfive.getTaskName());
            list.add(map);
         }
      }

      return list;
   }

   public Echartsfive findNameByTask(String taskid) {
      Echartsfive echartsfive = new Echartsfive();
      List<Map<String, Object>> list = this.findEchartsService.findNameByTask(taskid);
      if (list != null && list.size() != 0) {
         String task = (String)((Map)list.get(0)).get("taskName");
         echartsfive.setTaskName(task);
      }

      return echartsfive;
   }

   @RequestMapping({"/multiplsix"})
   @ResponseBody
   public List<Echartssix> findBymultiplSix(@RequestBody String[] taskidarr) throws IOException {
      ArrayList<Echartssix> list = new ArrayList();
      if (taskidarr != null || taskidarr.length != 0) {
         for(String string : taskidarr) {
            Echartssix echartssix = this.findNameByTaskidSix(string);
            list.add(echartssix);
         }
      }

      return list;
   }

   @RequestMapping({"/multipleseven"})
   @ResponseBody
   public List<Echartsseven> findNameBymultipleSeven(@RequestBody String[] taskidarr) throws IOException {
      ArrayList<Echartsseven> list = new ArrayList();
      if (taskidarr != null || taskidarr.length != 0) {
         for(String string : taskidarr) {
            Echartsseven echartsseven = this.findNameByTaskidSeven(string);
            list.add(echartsseven);
         }
      }

      return list;
   }
}
