package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleFastManage;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.core.TFastManageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/fastmanage"})
public class TFastManageController {
   @Autowired
   private TFastManageService fastManageService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/fastmanage";
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public DataGridVO<TConsoleFastManage> query(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TConsoleFastManage> list = this.fastManageService.query(pageInfo);
      DataGridVO<TConsoleFastManage> vo = new DataGridVO<TConsoleFastManage>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/add"})
   @ResponseBody
   public void add(HttpServletRequest request, HttpServletResponse response, String datatype, Integer isfastimport, Integer isfastexport) {
      TConsoleFastManage tConsoleFastManage = new TConsoleFastManage();
      tConsoleFastManage.setDatabasetype(datatype);
      tConsoleFastManage.setFastexport(isfastexport);
      tConsoleFastManage.setFastimport(isfastimport);
      new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Date date = new Date();
      tConsoleFastManage.setCreatetime(date);
      this.fastManageService.save(tConsoleFastManage);
   }

   @RequestMapping({"/modify"})
   @ResponseBody
   public void modify(HttpServletRequest request, HttpServletResponse response, String id, Integer isfastimport, Integer isfastexport) {
      TConsoleFastManage tConsoleFastManage = new TConsoleFastManage();
      tConsoleFastManage.setId(id);
      tConsoleFastManage.setFastexport(isfastexport);
      tConsoleFastManage.setFastimport(isfastimport);
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      Date date = new Date();
      String date1 = sdf.format(date);
      this.fastManageService.update(tConsoleFastManage, date1);
   }

   @RequestMapping({"/remove"})
   @ResponseBody
   public void remove(HttpServletRequest request, HttpServletResponse response, String id) {
      this.fastManageService.remove(id);
   }

   @RequestMapping({"/getdatatype"})
   @ResponseBody
   public List<ComboboxVO> getdatatype() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingType em : EdataMappingType.values()) {
         ComboboxVO vo = new ComboboxVO(em.getName(), em.getName());
         list.add(vo);
      }

      return list;
   }

   @RequestMapping({"/getdatatypebyid"})
   @ResponseBody
   public List<TConsoleFastManage> getdatatypebyid(String id) {
      return this.fastManageService.getdatatypebyid(id);
   }

   @RequestMapping({"/getdatatypebyname"})
   @ResponseBody
   public boolean getdatatypebyname(String name) {
      List<TConsoleFastManage> list = this.fastManageService.getdatatypebyname(name);
      boolean flag = true;

      for(int i = 0; i < list.size(); ++i) {
         if (name.equals(((TConsoleFastManage)list.get(i)).getDatabasetype())) {
            flag = false;
         } else {
            flag = true;
         }
      }

      return flag;
   }
}
