package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataScope;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldDetailReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldlistReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.FieldlistRuleReportVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ReportCheckboxVO;
import com.chenyang.nse.bussiness.tools.DataSourceTools;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDataScopeDao extends BaseDao<TCoreDataScope, String> {
   public List<Map<String, Object>> getDatacount() {
      String sql = "select scope_id, count(0) as count FROM t_core_scope_field AS a, t_core_table_field AS b WHERE\tb.id = a.tablefield_id   GROUP BY a.scope_id";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<FieldlistReportVO> getFieldList(String projectid, String type, String directory_name, String tablename, String columnname) {
      String sql = "";
      if ("0".equals(type)) {
         sql = "select x.projectid,x.projectname,y.columnid,x.tschema,x.tablename,x.columnname,y.directory_name,x.datasystemid  from ( select a.projectname,b.projectid, b.tschema,b.tablename,b.columnname,b.datasystemid  from t_core_project_info a LEFT JOIN " + projectid + " b on a.realprojectname=b.projectid) x, (select c.id,c.directory_name,e.datasystem_id,e.id as columnid,e.tschemas,e.\"names\",e.\"fields\",e.flag from t_core_compliance_directory c,t_core_field_directory d,t_core_table_field e where c.id=d.directory_id and d.tablefield_id=e.id )y where x.tschema=y.tschemas and x.tablename=y.\"names\" and x.columnname=y.\"fields\"";
         if (!"".equals(directory_name) && !"0".equals(directory_name)) {
            sql = sql + " and y.id='" + directory_name + "'";
         }

         if (tablename != null && !"".equals(tablename)) {
            sql = sql + " and x.tablename='" + tablename + "'";
         }

         if (columnname != null && !"".equals(columnname)) {
            sql = sql + " and x.columnname='" + columnname + "'";
         }
      } else if ("1".equals(type)) {
         sql = "select x.projectid,x.projectname,y.columnid,x.tschema,x.tablename,x.columnname,y.directory_name from ( select a.projectname,b.projectid, b.tschema,b.tablename,b.columnname from t_core_project_info a LEFT JOIN " + projectid + " b on a.realprojectname=b.projectid) x, (select c.id,c.scope_name as directory_name,e.datasystem_id,e.id as columnid,e.tschemas,e.\"names\",e.\"fields\",e.flag from t_core_data_scope c,t_core_scope_field d,t_core_table_field e where c.scope_id=d.scope_id and d.tablefield_id=e.id )y where x.tschema=y.tschemas and x.tablename=y.\"names\" and x.columnname=y.\"fields\"";
         if (!"".equals(directory_name) && !"0".equals(directory_name)) {
            sql = sql + " and y.id='" + directory_name + "'";
         }

         if (tablename != null && !"".equals(tablename)) {
            sql = sql + " and x.tablename='" + tablename + "'";
         }

         if (columnname != null && !"".equals(columnname)) {
            sql = sql + " and x.columnname='" + columnname + "'";
         }
      } else if ("2".equals(type)) {
         sql = "select x.projectid,x.projectname,y.columnid,x.tschema,x.tablename,x.columnname,y.directory_name from ( select a.projectname,b.projectid, b.tschema,b.tablename,b.columnname from t_core_project_info a LEFT JOIN " + projectid + " b on a.realprojectname=b.projectid) x, (select c.id,c.sensitive_name as directory_name,e.datasystem_id,e.id as columnid,e.tschemas,e.\"names\",e.\"fields\",e.flag from t_core_sensitive_level c,t_core_field_sensitive d,t_core_table_field e where c.id=d.sensitive_id and d.tablefield_id=e.id )y where x.tschema=y.tschemas and x.tablename=y.\"names\" and x.columnname=y.\"fields\"";
         if (!"".equals(directory_name) && !"0".equals(directory_name)) {
            sql = sql + " and y.id='" + directory_name + "'";
         }

         if (tablename != null && !"".equals(tablename)) {
            sql = sql + " and x.tablename='" + tablename + "'";
         }

         if (columnname != null && !"".equals(columnname)) {
            sql = sql + " and x.columnname='" + columnname + "'";
         }
      }

      sql = DataSourceTools.dealSqlFormat(sql);
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<FieldlistRuleReportVO> getFieldListRule(PageInfo pageInfo, String type, String directory_name, String tablename, String columnname) {
      String sql = "";
      if ("0".equals(type)) {
         sql = "select id,directory_name directory_name,datasystem_name, tschemas as tschema,names as tablename,fields as columnname from t_view_compliance_directory where 1=1 ";
         if (!"".equals(directory_name)) {
            sql = sql + " and directory_name='" + directory_name + "'";
         }

         if (tablename != null && !"".equals(tablename)) {
            sql = sql + " and names='" + tablename + "'";
         }

         if (columnname != null && !"".equals(columnname)) {
            sql = sql + " and fields='" + columnname + "'";
         }
      } else if ("1".equals(type)) {
         sql = "select id,scope_name directory_name,datasystem_name, tschemas as tschema,names as tablename,fields as columnname from t_view_data_scope where 1=1";
         if (!"".equals(directory_name)) {
            sql = sql + " and scope_name='" + directory_name + "'";
         }

         if (tablename != null && !"".equals(tablename)) {
            sql = sql + " and names='" + tablename + "'";
         }

         if (columnname != null && !"".equals(columnname)) {
            sql = sql + " and fields='" + columnname + "'";
         }
      } else if ("2".equals(type)) {
         sql = "select id,sensitive_name directory_name,datasystem_name, tschemas as tschema,names as tablename,fields as columnname from t_view_sensitive_level where 1=1";
         if (!"".equals(directory_name)) {
            sql = sql + " and sensitive_name='" + directory_name + "'";
         }

         if (tablename != null && !"".equals(tablename)) {
            sql = sql + " and names='" + tablename + "'";
         }

         if (columnname != null && !"".equals(columnname)) {
            sql = sql + " and fields='" + columnname + "'";
         }
      }

      return this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<ReportCheckboxVO> getCoreDataScopeList() {
      String sql = XmlTool.getSql("datascope", "getCoreDataScopeList");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ReportCheckboxVO.class)).getResultList();
   }

   public List<FieldDetailReportVO> getFieldDetail(String columnid) {
      String sql = XmlTool.getSql("datascope", "getFieldDetail");
      return this.getSession().createNativeQuery(sql).setParameter("columnid", columnid).setResultTransformer(Transformers.aliasToBean(FieldDetailReportVO.class)).getResultList();
   }

   public long getDatacountByproject(String table) {
      String sql = "select  count(0) as count FROM t_core_scope_field AS a, (select a.id from t_core_table_field as a," + table + " as b where a.tschemas = b.tschema and a.names = b.tablename and a.fields = b.columnname  ) AS b WHERE\tb.id = a.tablefield_id";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public int insert(String project) {
      String sql = "insert into t_view_data_scope_project select UUID() as id,'' as flag,'' as note,y.columnid,x.columnname,x.datasystemid,y.directory_name, x.projectid,x.projectname,x.tablename,x.tschema from ( select a.projectname,b.projectid, b.tschema,b.tablename,b.columnname,b.datasystemid  from t_core_project_info a LEFT JOIN " + project + " b on a.realprojectname=b.projectid) x, (select c.id,c.scope_name as directory_name,e.datasystem_id,e.id as columnid,e.tschemas,e.`names`,e.`fields`,e.flag from t_core_data_scope c,t_core_scope_field d,t_core_table_field e where c.scope_id=d.scope_id and d.tablefield_id=e.id )y where x.tschema=y.tschemas and x.tablename=y.`names` and x.columnname=y.`fields`";
      int size = this.getSession().createNativeQuery(sql).executeUpdate();
      return size;
   }

   public List<Map<String, Object>> getEachDatacount(String name) {
      String sql = "select projectname, count(0) as count FROM t_view_data_scope_project AS a where directory_name = '" + name + "' GROUP BY a.projectname";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, Object>> getmaxdatetid(String editionid) {
      String sql = "select id from t_core_data_scope where edition_id = '" + editionid + "' order by create_date desc limit 1";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public void saveDataScope(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public void deleteDataScope(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, Object>> relatedfandson(String scope_id, String edition_id) {
      String sql = "SELECT id FROM t_core_data_scope WHERE scope_id LIKE (CONCAT('" + scope_id + "', '%')) AND edition_id = '" + edition_id + "'";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public void saveExcelData(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }
}
