package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.tools.DataSourceTools;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreProjectFindruleDao extends BaseDao<TCoreProjectFindrule, String> {
   public List<Map<String, Object>> getProjectFindRule() {
      String sql = "SELECT a.id id,a.dataarea_id dataarea_id,b.dataarea dataarea,a.desensitizationrule desensitizationrule,a.desensitizationruledemo desensitizationruledemo FROM t_core_dataarea_desensitizationrule a,t_core_dataarea b WHERE a.dataarea_id = b.id";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public void defaultRowClear(String project_id, String dataarea_id, String rulestyle) {
      String sql = "update t_core_project_findrule A set A.defaultrule = '0'  where A.project_id='" + project_id + "' and A.dataarea_id = '" + dataarea_id + "' and A.rulestyle = '" + rulestyle + "'";
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public void defaultRow(String project_id, String dataarea_id, String rule_id, String rulestyle) {
      String sql = "update t_core_project_findrule A set A.defaultrule = '1'  where A.project_id='" + project_id + "' and A.dataarea_id = '" + dataarea_id + "'and A.rule_id = '" + rule_id + "' and A.rulestyle = '" + rulestyle + "'";
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, Object>> querySensitiveRuleList() {
      String sql = "select a.dataarea_id,a.id rule_id,b.`name` from t_console_searchregex a LEFT JOIN t_core_masking_ruleinfo b on a.dataarea_id=b.dataarea_id ";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> queryDbSensitiveRuleList(String dataSystemId) {
      String sql = "";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "select a.dataarea_id,b.id rule_id,b.`name` from t_console_searchregex a LEFT JOIN t_core_dg_command_rule b on a.dataarea_id=b.data_area_id LEFT JOIN t_core_datasystem c on c.dbtype = b.database_id where c.id = '" + dataSystemId + "' and b.is_default='1' ";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "select a.dataarea_id,b.id rule_id,b.\"name\" from t_console_searchregex a LEFT JOIN t_core_dg_command_rule b on a.dataarea_id=b.data_area_id LEFT JOIN t_core_datasystem c on c.dbtype = b.database_id where c.id = '" + dataSystemId + "' and b.is_default='1' ";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select a.dataarea_id,b.id rule_id,b.name from t_console_searchregex a LEFT JOIN t_core_dg_command_rule b on a.dataarea_id=b.data_area_id LEFT JOIN t_core_datasystem c on c.dbtype = b.database_id where c.id = '" + dataSystemId + "' and b.is_default='1' ";
      }

      sql = DataSourceTools.dealSqlFormat(sql);
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<Map<String, Object>> querySensitiveRuleList(String projectid) {
      String sql = "";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "select a.project_id,a.dataarea_id,a.rule_id,b.`name` from t_core_project_findrule a LEFT JOIN t_core_masking_ruleinfo b on a.rule_id=b.id where a.rulestyle='1' and a.defaultrule='1' and a.project_id='" + projectid + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "select a.project_id,a.dataarea_id,a.rule_id,b.\"name\" from t_core_project_findrule a LEFT JOIN t_core_masking_ruleinfo b on a.rule_id=b.id where a.rulestyle='1' and a.defaultrule='1' and a.project_id='" + projectid + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select a.project_id,a.dataarea_id,a.rule_id,b.name from t_core_project_findrule a LEFT JOIN t_core_masking_ruleinfo b on a.rule_id=b.id where a.rulestyle='1' and a.defaultrule='1' and a.project_id='" + projectid + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select a.project_id as \"project_id\",a.dataarea_id as \"dataarea_id\",a.rule_id as \"rule_id\",b.name as \"name\" from t_core_project_findrule a LEFT JOIN t_core_masking_ruleinfo b on a.rule_id=b.id where a.rulestyle='1' and a.defaultrule='1' and a.project_id='" + projectid + "'";
      }

      sql = DataSourceTools.dealSqlFormat(sql);
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public int delRuleByDataareaid(String dataareaid) {
      String sql = "delete from t_core_project_findrule where dataarea_id= '" + dataareaid + "'";
      return this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<TCoreMaskingRule> queryMaskingRule(String projectid) {
      String sql = "";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sql = "select b.id,b.mappletname,b.subjectarea, b.ruledemo,b.`name`,b.dataarea_id from t_core_project_findrule a,t_core_masking_ruleinfo b where a.rule_id=b.id and  b.name is not null and a.project_id='" + projectid + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sql = "select b.id,b.mappletname,b.subjectarea, b.ruledemo,b.\"name\",b.dataarea_id from t_core_project_findrule a,t_core_masking_ruleinfo b where a.rule_id=b.id and  b.name is not null and a.project_id='" + projectid + "'";
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = "select b.id,b.mappletname,b.subjectarea, b.ruledemo,b.name,b.dataarea_id from t_core_project_findrule a,t_core_masking_ruleinfo b where a.rule_id=b.id and  b.name is not null and a.project_id='" + projectid + "'";
      }

      sql = DataSourceTools.dealSqlFormat(sql);
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public void saveAllFind(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, Object>> selectFindRuleCount(String project_id) {
      String sql = "SELECT count(1) as s FROM t_core_project_findrule where project_id ='" + project_id + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT count(1) as \"s\" FROM t_core_project_findrule where project_id ='" + project_id + "'";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }
}
