package com.chenyang.nse.bussiness.dao.table.core.systemparameter;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.systemparameter.TCoreSystemparameter;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSystemparameterDao extends BaseDao<TCoreSystemparameter, String> {
   public List<Map<String, Object>> querySystemParameter(PageInfo pageInfo) {
      String sql = XmlTool.getSql("systemparameter", "querySystemParameter");
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).getResultList();
      return list;
   }

   public String getPathValueByName(String parametername) {
      String sql = XmlTool.getSql("systemparameter", "getPathValueByName");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("parametername", parametername).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return (String)((Map)list.get(0)).get("propertyvalue");
   }
}
