package com.chenyang.nse.bussiness.entity.orm.table.core.file;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Size;

@Entity
@Table(
   name = "T_CORE_FILE_STRUCTURE"
)
public class TCoreFileStructure extends TBaseEntity {
   private String filestructurename;
   private String filestructuregroup;
   private String codepage;
   private String skiprows;
   private String splitertype;
   @Transient
   @Size(
      max = 32
   )
   private String groupid;

   public String getGroupid() {
      return this.groupid;
   }

   public void setGroupid(String groupid) {
      this.groupid = groupid;
   }

   public TCoreFileStructure() {
   }

   public TCoreFileStructure(String filestructurename, String filestructuregroup, String codepage, String skiprows, String splitertype) {
      this.filestructurename = filestructurename;
      this.filestructuregroup = filestructuregroup;
      this.codepage = codepage;
      this.skiprows = skiprows;
      this.splitertype = splitertype;
   }

   public String getFilestructurename() {
      return this.filestructurename;
   }

   public void setFilestructurename(String filestructurename) {
      this.filestructurename = filestructurename;
   }

   public String getFilestructuregroup() {
      return this.filestructuregroup;
   }

   public void setFilestructuregroup(String filestructuregroup) {
      this.filestructuregroup = filestructuregroup;
   }

   public String getCodepage() {
      return this.codepage;
   }

   public void setCodepage(String codepage) {
      this.codepage = codepage;
   }

   public String getSkiprows() {
      return this.skiprows;
   }

   public void setSkiprows(String skiprows) {
      this.skiprows = skiprows;
   }

   public String getSplitertype() {
      return this.splitertype;
   }

   public void setSplitertype(String splitertype) {
      this.splitertype = splitertype;
   }

   public String toString() {
      return "TCoreFileStructure [filestructurename=" + this.filestructurename + ", filestructuregroup=" + this.filestructuregroup + ", codepage=" + this.codepage + ", skiprows=" + this.skiprows + ", splitertype=" + this.splitertype + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.codepage == null ? 0 : this.codepage.hashCode());
      result = 31 * result + (this.filestructuregroup == null ? 0 : this.filestructuregroup.hashCode());
      result = 31 * result + (this.filestructurename == null ? 0 : this.filestructurename.hashCode());
      result = 31 * result + (this.skiprows == null ? 0 : this.skiprows.hashCode());
      result = 31 * result + (this.splitertype == null ? 0 : this.splitertype.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreFileStructure other = (TCoreFileStructure)obj;
         if (this.codepage == null) {
            if (other.codepage != null) {
               return false;
            }
         } else if (!this.codepage.equals(other.codepage)) {
            return false;
         }

         if (this.filestructuregroup == null) {
            if (other.filestructuregroup != null) {
               return false;
            }
         } else if (!this.filestructuregroup.equals(other.filestructuregroup)) {
            return false;
         }

         if (this.filestructurename == null) {
            if (other.filestructurename != null) {
               return false;
            }
         } else if (!this.filestructurename.equals(other.filestructurename)) {
            return false;
         }

         if (this.skiprows == null) {
            if (other.skiprows != null) {
               return false;
            }
         } else if (!this.skiprows.equals(other.skiprows)) {
            return false;
         }

         if (this.splitertype == null) {
            if (other.splitertype != null) {
               return false;
            }
         } else if (!this.splitertype.equals(other.splitertype)) {
            return false;
         }

         return true;
      }
   }
}
