package com.chenyang.nse.bussiness.entity.orm.table.core.masking;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_MASKING_HIVE"
)
public class TCoreMaskingHive extends TBaseEntity {
   private static final long serialVersionUID = -1403065098160237142L;
   private String taskid;
   private String datasystemid;
   private String dbschema;
   private String tablename;
   private String mappingkey;
   private String datadirection;

   public TCoreMaskingHive() {
   }

   public TCoreMaskingHive(String taskid, String datasystemid, String dbschema, String tablename, String mappingkey, String datadirection) {
      this.taskid = taskid;
      this.datasystemid = datasystemid;
      this.dbschema = dbschema;
      this.tablename = tablename;
      this.mappingkey = mappingkey;
      this.datadirection = datadirection;
   }

   public String getTaskid() {
      return this.taskid;
   }

   public void setTaskid(String taskid) {
      this.taskid = taskid;
   }

   public String getDatasystemid() {
      return this.datasystemid;
   }

   public void setDatasystemid(String datasystemid) {
      this.datasystemid = datasystemid;
   }

   public String getDbschema() {
      return this.dbschema;
   }

   public void setDbschema(String dbschema) {
      this.dbschema = dbschema;
   }

   public String getTablename() {
      return this.tablename;
   }

   public void setTablename(String tablename) {
      this.tablename = tablename;
   }

   public String getMappingkey() {
      return this.mappingkey;
   }

   public void setMappingkey(String mappingkey) {
      this.mappingkey = mappingkey;
   }

   public String getDatadirection() {
      return this.datadirection;
   }

   public void setDatadirection(String datadirection) {
      this.datadirection = datadirection;
   }

   public String toString() {
      return "TCoreMaskingHive [taskid=" + this.taskid + ", datasystemid=" + this.datasystemid + ", dbschema=" + this.dbschema + ", tablename=" + this.tablename + ", mappingkey=" + this.mappingkey + ", datadirection=" + this.datadirection + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.datadirection == null ? 0 : this.datadirection.hashCode());
      result = 31 * result + (this.datasystemid == null ? 0 : this.datasystemid.hashCode());
      result = 31 * result + (this.dbschema == null ? 0 : this.dbschema.hashCode());
      result = 31 * result + (this.mappingkey == null ? 0 : this.mappingkey.hashCode());
      result = 31 * result + (this.tablename == null ? 0 : this.tablename.hashCode());
      result = 31 * result + (this.taskid == null ? 0 : this.taskid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreMaskingHive other = (TCoreMaskingHive)obj;
         if (this.datadirection == null) {
            if (other.datadirection != null) {
               return false;
            }
         } else if (!this.datadirection.equals(other.datadirection)) {
            return false;
         }

         if (this.datasystemid == null) {
            if (other.datasystemid != null) {
               return false;
            }
         } else if (!this.datasystemid.equals(other.datasystemid)) {
            return false;
         }

         if (this.dbschema == null) {
            if (other.dbschema != null) {
               return false;
            }
         } else if (!this.dbschema.equals(other.dbschema)) {
            return false;
         }

         if (this.mappingkey == null) {
            if (other.mappingkey != null) {
               return false;
            }
         } else if (!this.mappingkey.equals(other.mappingkey)) {
            return false;
         }

         if (this.tablename == null) {
            if (other.tablename != null) {
               return false;
            }
         } else if (!this.tablename.equals(other.tablename)) {
            return false;
         }

         if (this.taskid == null) {
            if (other.taskid != null) {
               return false;
            }
         } else if (!this.taskid.equals(other.taskid)) {
            return false;
         }

         return true;
      }
   }
}
