package com.chenyang.nse.bussiness.enumeration.datamapping;

public enum EdataDbType {
   MYSQL("MYSQL", new String[]{"JDBC", "LOAD"}, new String[]{"JDBC", "LOAD"}),
   ORACLE("ORACLE", new String[]{"JDBC"}, new String[]{"JDBC"}),
   MSSQLSERVER("MSSQLSERVER", new String[]{"JDBC"}, new String[]{"JDBC"}),
   DB2("DB2", new String[]{"JDBC", "LOAD"}, new String[]{"JDBC"}),
   INFORMIX("INFORMIX", new String[]{"JDBC"}, new String[]{"JDBC"}),
   SYBASE("SYBASE", new String[]{"JDBC", "LOAD"}, new String[]{"JDBC", "LOAD"}),
   FILESYSTEM("FILESYSTEM", new String[]{"JDBC"}, new String[]{"JDBC"}),
   HIVE("HIVE", new String[]{"JDBC", "LOAD"}, new String[]{"LOAD"}),
   SYBASE_IQ("SYBASE_IQ", new String[]{"JDBC", "LOAD"}, new String[]{"JDBC"}),
   TERADATA("TERADATA", new String[]{"LOAD"}, new String[]{"JDBC", "MULTILOAD"}),
   MARIADB("MARIADB", new String[]{"JDBC"}, new String[]{"JDBC"}),
   GREENPLUM("GREENPLUM", new String[]{"JDBC", "LOAD"}, new String[]{"JDBC"}),
   RAPIDSDB("RAPIDSDB", new String[]{"JDBC", "LOAD"}, new String[]{"JDBC", "LOAD"});

   private String name;
   private String[] importtype;
   private String[] exporttype;

   private EdataDbType(String name, String[] importtype, String[] exporttype) {
      this.name = name;
      this.importtype = importtype;
      this.exporttype = exporttype;
   }

   public String getName() {
      return this.name;
   }

   public void setName(String name) {
      this.name = name;
   }

   public String[] getImporttype() {
      return this.importtype;
   }

   public void setImporttype(String[] importtype) {
      this.importtype = importtype;
   }

   public String[] getExporttype() {
      return this.exporttype;
   }

   public void setExporttype(String[] exporttype) {
      this.exporttype = exporttype;
   }

   public static String[] getImporttype(String name) {
      String[] type = new String[0];

      for(EdataDbType em : values()) {
         if (name.equals(em.getName())) {
            type = em.getImporttype();
            break;
         }
      }

      return type;
   }

   public static String[] getExporttype(String name) {
      String[] type = new String[0];

      for(EdataDbType em : values()) {
         if (name.equals(em.getName())) {
            type = em.getExporttype();
            break;
         }
      }

      return type;
   }
}
