package com.chenyang.nse.bussiness.job;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@DisallowConcurrentExecution
public class MaskingTaskKmJob implements Job {
   public void execute(JobExecutionContext context) throws JobExecutionException {
      SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
      JobDetail jobDetail = context.getJobDetail();
      String schedulerId = jobDetail.getJobDataMap().getString("schedulerId");
      String rulesType = jobDetail.getJobDataMap().getString("rulesType");

      try {
         System.out.println("执行任务啦");
         System.out.println("执行完成啦");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
