package com.chenyang.nse.bussiness.odbc.business;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.chenyang.nse.bussiness.odbc.po.RuleReqInfo;
import com.chenyang.nse.bussiness.tools.spring.SpringUtil;
import com.chenyang.nse.bussiness.tools.strategy.StrategyData;
import java.io.IOException;

public class MaskApi implements OdbcApiCallable {
   public Object invoke(byte[] data) {
      try {
         ObjectMapper mapper = new ObjectMapper();
         RuleReqInfo info = null;
         info = (RuleReqInfo)mapper.readValue(data, RuleReqInfo.class);
         String projectId = info.getProject();

         try {
            StrategyData strategyData = (StrategyData)SpringUtil.getBean(StrategyData.class);
            String strategyjson = strategyData.getDesensitizationStrategy(projectId, "1");
            return strategyjson;
         } catch (Exception e) {
            e.printStackTrace();
            return "{}";
         }
      } catch (IOException e) {
         e.printStackTrace();
         return "{}";
      }
   }
}
