package com.chenyang.nse.bussiness.service.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataFileGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.SensitiveColumn;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataAreaVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataFileGroupVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectFindruleVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSearchregexVO;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Workbook;

public interface SearchRegexService {
   List<TConsoleSearchregex> query(PageInfo pageInfo);

   List<TCoreSearchregexVO> querySearchregex(String dataarea, String rulename, PageInfo pageInfo);

   List<TCoreSearchregexVO> querySearchregexById(String id);

   List<TCoreDataArea> queryAllDataArea();

   List<String> queryDataarea();

   List<TCoreSearchregexVO> queryDataAreaSearchregexByProjectid(String projectid);

   List<TConsoleSearchregex> queryAllSearchRegex();

   void remove(List<String> idlist);

   int queryRuleCount(String dataareaId);

   void removeDataarea(String dataareaId);

   boolean checkNameExit(String name);

   void save(TConsoleSearchregex tConsoleSearchregex);

   void saveConsoleSearchregex(TConsoleSearchregex tConsoleSearchregex, String user);

   List<TConsoleSearchregex> querySearchRegex(String flag);

   List<TCoreProjectFindruleVO> queryFindrule(String projectid);

   List<TCoreSearchregexVO> queryDataAreaSearchregex(String dataarea, String rulename);

   Map<String, List<SensitiveColumn>> getAllTableColumnsByName(int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo);

   Map<String, List<SensitiveColumn>> getAllFileColumnsByName(String jiegou, TCoreDatasystem datasystem, List<String> schemas, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo);

   Map<String, List<SensitiveColumn>> getAllTableColumnsByContent(int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo, String datasystemid);

   List<ComboboxVO> querySensitiveGroups();

   boolean matches(String methodName, int maxLength, String testString, int level);

   void setYearNow();

   List<TConsoleSearchregex> initEditRegex(String rowid);

   void init();

   Map<String, List<SensitiveColumn>> getAllFileColumnsByContent(String jiegou, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo);

   Map<String, List<SensitiveColumn>> getAlldmpTableColumnsByContent(String multiDempFile, int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo, String datasystemid, String dmptype);

   void delDataarea(String dataareaid);

   void setDefault(String ruleid);

   void setOtherDefault(String id);

   List<ComboboxVO> queryAllDataareaid();

   void saveConsoleSearchregex2(TConsoleSearchregex searchRegex, String username, List<Object> selectdatefilelist);

   void saveConsoleSearchregex3(TConsoleSearchregex searchRegex, String username);

   void removeselectdatefilelist(String id);

   void saveselectdatefilelist(TCoreDataFileGroup o);

   List<Map<String, String>> querydatafileById(String rowid, String projectid);

   List<TCoreDataFileGroup> querydatafileById(String rowid);

   List<TCoreDataFileGroup> querydatafileBName(String name);

   List<TCoreDataArea> queryDataareaByProjectid(String projectid);

   List<ComboboxVO> queryDatafileList(String id);

   List<TConsoleSearchregex> getBydatafileid(String dataarea_id);

   boolean dicmatch(String dictionaryClass, String matchingway, String testString);

   List<TCoreDataFileGroupVO> queryMutexDataarea(String dataareaid);

   List<TCoreDataFileGroupVO> queryMutexDataareaByrule(String dataareaid, String rulename);

   List<TConsoleSearchregex> querySearchregexByDaid(String dataarea_id);

   TCoreDataArea saveTCoreDataArea(TCoreDataArea tCoreDataArea);

   void removeTCoreDataArea(List<String> idlist);

   TCoreDataArea queryDataareaById(String id);

   boolean checkNameExitDataArea(String dataarea, String id);

   List<TCoreDataArea> queryAllDataarea();

   List<TcoreTaskFindrule> queryTcoreTaskFindruleByRuleid(String ruleid);

   List<TCoreDataArea> queryAllDataarea(Map<String, Object> params);

   String importExcel(Workbook wb, String username);

   TCoreDataArea saveDataArea(TCoreDataAreaVO tCoreDataAreaVO);

   TConsoleSearchregex saveSearchRegex(TCoreSearchregexVO tCoreSearchregexVO);

   TCoreDataArea queryByDataArea(String dataArea);

   boolean checkNameExit(String name, String dataareaId, String id);

   boolean checkNameExit(String name, String dataAreaId, String flag, String regex);
}
