package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubset;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsetcolumns;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSubsettask;
import com.chenyang.nse.bussiness.entity.vo.SubsetTaskEngineVO;
import java.util.List;

public interface SubsetService {
   boolean checkSubsetName(String subsetName);

   List<TCoreSubset> querySubset(String dataSystemId, String schema);

   List<TCoreSubsetcolumns> querySubsetColumns(String subsetid);

   void delete(String id);

   void deleteByName(String subsetName);

   TCoreSubset saveSubsetAndColumns(TCoreSubset subset, List<String> subsetColumns);

   List<TCoreSubset> queryAllSubset();

   String saveSubsetTask(TCoreSubsettask subsetTask, String userid);

   List<TCoreSubsettask> queryTask(PageInfo pageInfo);

   void updateSubsetTask(String taskId, String status);

   boolean checkTaskName(String taskName);

   void deleteSubsetTask(String subsetTaskId);

   List<TCoreSubsettask> queryTaskByEngineId(String engineid, PageInfo pageInfo);

   TCoreSubset querySubsetById(String id);

   TCoreSubsettask queryTaskById(String id);

   String executeTask(TCoreSubsettask subsetTask);

   List<TCoreSubsettask> queryTaskBySubsetId(String subsetId);

   String saveSubsetTask(TCoreSubsettask subsetTask, List<String> changedRuleIds, String userid);

   SubsetTaskEngineVO getEngineInfoOfSubsetTask(String subsetTaskId);
}
