package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.core.TCoreBusinessSystemDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreBussinessSystem;
import com.chenyang.nse.bussiness.service.core.IBussinessSystemService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessSystemServiceImpl implements IBussinessSystemService {
   @Autowired
   private TCoreBusinessSystemDao bussinessSystemDao;

   public void delete(TCoreBussinessSystem bussinessSystem) {
      this.bussinessSystemDao.remove(bussinessSystem);
   }

   public void saveOrUpdate(TCoreBussinessSystem bussinessSystem) {
      bussinessSystem.setCreatedatetime((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).format(new Date()));
      this.bussinessSystemDao.saveOrUpdate(bussinessSystem);
   }

   public List<TCoreBussinessSystem> queryList(TCoreBussinessSystem condition) {
      return this.bussinessSystemDao.query(condition);
   }

   public int getTotalCount() {
      return this.bussinessSystemDao.queryAll().size();
   }

   public TCoreBussinessSystem queryById(String bussinessSystemId) {
      Criterion cgroupname = Restrictions.eq("id", bussinessSystemId);
      TCoreBussinessSystem tCoreBussinessSystem = (TCoreBussinessSystem)this.bussinessSystemDao.queryUnique(new Criterion[]{cgroupname});
      return tCoreBussinessSystem;
   }
}
